﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 切换场景层信息
    /// </summary>
    public class TransitionLogicLayerInfo : ModelBase
    {
        #region BackgroundScene -- 所属背景层

        private string backgroundScene;
        /// <summary>
        /// 所属背景层
        /// </summary>
        public string BackgroundScene
        {
            get { return backgroundScene; }
            set { backgroundScene = value; this.RaisePropertyChanged(nameof(BackgroundScene)); }
        }

        #endregion

        #region LayerIdentifier -- 逻辑层

        private string layerIdentifier;
        /// <summary>
        /// 逻辑层
        /// </summary>
        public string LayerIdentifier
        {
            get { return layerIdentifier; }
            set { layerIdentifier = value; this.RaisePropertyChanged(nameof(LayerIdentifier)); }
        }

        #endregion

        #region StateIdentifier -- 状态点

        private string stateIdentifier;
        /// <summary>
        /// 触发器Geom值
        /// </summary>
        public string StateIdentifier
        {
            get { return stateIdentifier; }
            set { stateIdentifier = value; this.RaisePropertyChanged(nameof(StateIdentifier)); }
        }

        #endregion

        #region SceneIdentifier -- 场景

        private string sceneIdentifier;
        /// <summary>
        /// 场景
        /// </summary>
        public string SceneIdentifier
        {
            get { return sceneIdentifier; }
            set { sceneIdentifier = value; this.RaisePropertyChanged(nameof(SceneIdentifier)); }
        }

        #endregion

        #region ControlObject -- 控制对象值

        private string controlObject;
        /// <summary>
        /// 控制对象值
        /// </summary>
        public string ControlObject
        {
            get { return controlObject; }
            set { controlObject = value; this.RaisePropertyChanged(nameof(ControlObject)); }
        }

        #endregion

        #region IsContinued -- 是否点击了继续

        private bool isContinued;
        /// <summary>
        /// 是否点击了继续
        /// </summary>
        public bool IsContinued
        {
            get { return isContinued; }
            set { isContinued = value; this.RaisePropertyChanged(nameof(IsContinued)); }
        }

        #endregion
    }
}
