﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// RichTextListCellEdit.xaml 的交互逻辑
    /// </summary>
    public partial class RichTextListCellEdit : ListCellEditBase
    {
        /// <summary>
        /// 富文本左侧
        /// </summary>
        public const string RICH_TEXT_LEFT = "<fo:wrapper xmlns:fo=\"http://www.w3.org/1999/XSL/Format\"><![CDATA[";

        /// <summary>
        /// 富文本右侧
        /// </summary>
        public const string RICH_TEXT_RIGHT = "]]></fo:wrapper>";

        public RichTextListCellEdit()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 数据上下文改变时触发
        /// </summary>
        /// <param name="e">事件参数</param>
        protected override void OnDataContextChanged(DependencyPropertyChangedEventArgs e)
        {
            DevExpress.Xpf.Grid.EditGridCellData cellData = e.NewValue as DevExpress.Xpf.Grid.EditGridCellData;

            this.IsSendToPreview = false;
            this.PART_Text.EditValue = this.GetTextFromRichText(cellData?.Value?.ToString());
            this.IsSendToPreview = true;
        }

        /// <summary>
        /// 值改变时触发
        /// </summary>
        protected virtual void EditValueChanged(object sender, DevExpress.Xpf.Editors.EditValueChangedEventArgs e)
        {
            // 是否需要发送至预览
            if (!this.IsSendToPreview)
                return;

            // 预览连接不存在
            if (ApplicationDomainEx.PreviewConn == null)
                return;

            DevExpress.Xpf.Grid.EditGridCellData cellData = this.DataContext as DevExpress.Xpf.Grid.EditGridCellData;
            if (cellData == null)
                return;

            GridColumnControlFieldDefinition columnDefinition = cellData.Column.DataContext as GridColumnControlFieldDefinition;
            if (columnDefinition == null)
                return;

            string richText = $"{RICH_TEXT_LEFT}{e.NewValue?.ToString() ?? string.Empty}{RICH_TEXT_RIGHT}";

            // 设置值
            IDictionary<string, object> dic = cellData.Row as IDictionary<string, object>;
            dic[columnDefinition.FieldName] = richText;

            // 向Viz发送指令
            this.VizCommandControlObjectService.SetControlObjectListValue(
                ApplicationDomainEx.PreviewConn,
                ApplicationDomainEx.CurrentPage.GetVizScene(),
                columnDefinition.ControlObject.TreeNodePath,
                columnDefinition.ControlField.FieldIdentifier,
                cellData.RowData.RowHandle.Value,
                columnDefinition.FieldName,
                richText);
        }

        /// <summary>
        /// 显示编辑窗口
        /// </summary>
        private void EditClick(object sender, RoutedEventArgs e)
        {
            DevExpress.Xpf.Grid.EditGridCellData cellData = this.DataContext as DevExpress.Xpf.Grid.EditGridCellData;
            if (cellData == null)
                return;

            GridColumnControlFieldDefinition columnDefinition = cellData.Column.DataContext as GridColumnControlFieldDefinition;
            if (columnDefinition == null)
                return;

            FieldEditWindow window = this.GetFieldEditWindow();
            FieldEditWindowModel vm = window.DataContext as FieldEditWindowModel;

            vm.Update(this, columnDefinition, cellData.RowData.RowHandle.Value, cellData.Row as ExpandoObject);

            window.ShowInTaskbar = true;
            window.Visibility = Visibility.Visible;
        }

        /// <summary>
        /// 从富文本中获取文本内容
        /// </summary>
        /// <param name="richText">富文本</param>
        /// <returns>文本内容</returns>
        private string GetTextFromRichText(string richText)
        {
            if (string.IsNullOrWhiteSpace(richText))
                return richText;

            string str = richText.Replace(RICH_TEXT_LEFT, string.Empty);
            str = str.Replace(RICH_TEXT_RIGHT, string.Empty);

            return str;
        }

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="columnDefinition">列定义</param>
        /// <param name="rowHandle">行号</param>
        /// <param name="row">行数据</param>
        public override void UpdateEditValue(GridColumnControlFieldDefinition columnDefinition, int rowHandle, ExpandoObject row)
        {
            IDictionary<string, object> dic = row as IDictionary<string, object>;
            if (dic == null)
            {
                this.PART_Text.EditValue = null;
                return;
            }

            this.PART_Text.EditValue = this.GetTextFromRichText(dic[columnDefinition.FieldName]?.ToString());
        }
    }
}
