﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media.Imaging;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    public class ImageShowViewModel:ViewModelBase
    {
        /// <summary>
        /// 绑定图片
        /// </summary>
        private BitmapImage showImage;

        public BitmapImage ShowImage
        {
            get { return showImage; }
            set { showImage = value; this.RaisePropertyChanged(nameof(ShowImage)); }
        }

        /// <summary>
        /// bitmap 转BitmapImage
        /// </summary>
        /// <param name="bitmap"></param>
        /// <returns></returns>
        public BitmapImage BitmapToBitmapImage(System.Drawing.Bitmap bitmap)
        {
            System.Drawing.Bitmap ImageOriginalBase = new System.Drawing.Bitmap(bitmap);
            BitmapImage bitmapImage = new BitmapImage();
            using (System.IO.MemoryStream ms = new System.IO.MemoryStream())
            {
                ImageOriginalBase.Save(ms, System.Drawing.Imaging.ImageFormat.Png);
                bitmapImage.BeginInit();
                bitmapImage.StreamSource = ms;
                bitmapImage.CacheOption = BitmapCacheOption.OnLoad;
                bitmapImage.EndInit();
                bitmapImage.Freeze();
            }
            return bitmapImage;

        }


    }
}
