﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 控制对象实体
    /// </summary>
    public class ControlObjectEntity
    {
        /// <summary>
        /// 编号
        /// </summary>
        [BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// 所属模板ID或页ID
        /// </summary>
        public Guid PageID { get; set; }

        /// <summary>
        /// 所在场景节点名称
        /// </summary>
        public string TreeNodeName { get; set; }

        /// <summary>
        /// 所在场景节点路径
        /// </summary>
        public string TreeNodePath { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 字段描述
        /// </summary>
        public string FieldDetails { get; set; }

        /// <summary>
        /// 自定义字段描述
        /// </summary>
        public string CustomFieldDetails { get; set; }

        /// <summary>
        /// 使用所有的控制器
        /// </summary>
        public bool UseAllDirectors { get; set; }

        /// <summary>
        /// 是否为切换逻辑层
        /// </summary>
        public bool TransitionLogic { get; set; }

        /// <summary>
        /// 切换逻辑层名
        /// </summary>
        public string LayerIdentifier { get; set; }

        /// <summary>
        /// 进入方式
        /// </summary>
        public string StateIdentifier { get; set; }

        /// <summary>
        /// 背景层
        /// </summary>
        public string BackgroundScene { get; set; }
    }
}
