﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 列编辑面板单元格模板选择器
    /// </summary>
    public class ListEditPanelCellTemplateSelector : DataTemplateSelector
    {
        /// <summary>
        /// 文本模板
        /// </summary>
        public DataTemplate TextDataTemplate { get; set; }

        /// <summary>
        /// 富文本模板
        /// </summary>
        public DataTemplate RichTextDataTemplate { get; set; }

        /// <summary>
        /// 图片模板
        /// </summary>
        public DataTemplate ImageDataTemplate { get; set; }

        /// <summary>
        /// Bool
        /// </summary>
        public DataTemplate BooleanDataTemplate { get; set; }

        /// <summary>
        /// 数字
        /// </summary>
        public DataTemplate IntegerDataTemplate { get; set; }

        /// <summary>
        /// 浮点数字
        /// </summary>
        public DataTemplate FloatDataTemplate { get; set; }

        /// <summary>
        /// 二元组
        /// </summary>
        public DataTemplate DupletDataTemplate { get; set; }

        /// <summary>
        /// 三元组
        /// </summary>
        public DataTemplate TripletDataTemplate { get; set; }

        /// <summary>
        /// 字体
        /// </summary>
        public DataTemplate FontDataTemplate { get; set; }

        /// <summary>
        /// 筛选模板
        /// </summary>
        /// <param name="item">项</param>
        /// <param name="container">容器</param>
        /// <returns>数据模板</returns>
        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            GridCellData data = (GridCellData)item;
            GridColumnDefinition definition = data.Column.DataContext as GridColumnDefinition;

            if (definition == null)
                return null;

            switch (definition.Type)
            {
                case VizControlFieldType.none: return null;
                case VizControlFieldType.text: return this.TextDataTemplate;
                case VizControlFieldType.boolean: return this.BooleanDataTemplate;
                case VizControlFieldType.integer: return this.IntegerDataTemplate;
                case VizControlFieldType.@float: return this.FloatDataTemplate;
                case VizControlFieldType.richtext: return this.RichTextDataTemplate;
                case VizControlFieldType.image: return this.ImageDataTemplate;
                case VizControlFieldType.list: return this.TextDataTemplate;
                case VizControlFieldType.duplet: return this.DupletDataTemplate;
                case VizControlFieldType.triplet: return this.TripletDataTemplate;
                default: return null;
            }
        }
    }
}