﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Service
{
    /// <summary>
    /// 控制对象服务
    /// </summary>
    public class ControlObjectService
    {
        /// <summary>
        /// 保存控制字段
        /// </summary>
        /// <param name="pageBase">页或模板</param>
        /// <param name="fields">控制字段</param>
        public void SaveControlFields(PageModelBase pageBase, IList<ControlFieldNodeModel> fields)
        {
            Guid id = Guid.Empty;
            if (pageBase is PageTemplateModel template)
            {
                id = template.TemplateID;
            }
            else if (pageBase is PageModel page)
            {
                id = page.PageID;
            }

            ILiteCollection<ControlFieldEntity> collection = ApplicationDomainEx.ProjectDbContext.GetControlFiled(id);

            collection.DeleteAll();

            List<ControlFieldEntity> list = new List<ControlFieldEntity>();
            foreach (ControlFieldNodeModel field in fields)
            {
                ControlFieldEntity entity = new ControlFieldEntity();
                entity.FieldIdentifier = field.FieldIdentifier;
                entity.Value = field.Value;
                entity.Type = field.Type;

                list.Add(entity);
            }

            collection.Insert(list);
        }

        /// <summary>
        /// 保存控制字段
        /// </summary>
        /// <param name="pageBase">页或模板</param>
        /// <param name="fields">控制字段</param>
        public void SaveControlFields(PageModelBase pageBase, IList<ControlFieldEntity> fields)
        {
            Guid id = Guid.Empty;
            if (pageBase is PageTemplateModel template)
            {
                id = template.TemplateID;
            }
            else if (pageBase is PageModel page)
            {
                id = page.PageID;
            }

            ILiteCollection<ControlFieldEntity> collection = ApplicationDomainEx.ProjectDbContext.GetControlFiled(id);
            collection.DeleteAll();
            collection.Insert(fields);
        }

        /// <summary>
        /// 拷贝控制字段
        /// </summary>
        /// <param name="srcID">源ID</param>
        /// <param name="distID">目标ID</param>
        public void CopyControlFields(Guid srcID, Guid distID)
        {
            ILiteCollection<ControlFieldEntity> srcCollection = ApplicationDomainEx.ProjectDbContext.GetControlFiled(srcID);
            ILiteCollection<ControlFieldEntity> dstCollection = ApplicationDomainEx.ProjectDbContext.GetControlFiled(distID);

            dstCollection.DeleteAll();
            dstCollection.Insert(srcCollection.FindAll());
        }

        /// <summary>
        /// 获取控制字段
        /// </summary>
        /// <param name="pageBase">页或模板</param>
        /// <returns>控制字段</returns>
        public List<ControlFieldEntity> GetControlFields(PageModelBase pageBase)
        {
            Guid id = Guid.Empty;
            if (pageBase is PageTemplateModel template)
            {
                id = template.TemplateID;
            }
            else if (pageBase is PageModel page)
            {
                id = page.PageID;
            }

            ILiteCollection<ControlFieldEntity> collection = ApplicationDomainEx.ProjectDbContext.GetControlFiled(id);

            return collection.FindAll().ToList();
        }

        /// <summary>
        /// 更新控制字段值
        /// </summary>
        /// <param name="models">模型</param>
        /// <param name="entitys">实体</param>
        public void UpdateControlFieldValue(IList<ControlFieldNodeModel> models, IList<ControlFieldEntity> entitys)
        {
            Dictionary<string, ControlFieldEntity> dic = entitys.ToDictionary(p => p.FieldIdentifier, p => p);

            foreach (ControlFieldNodeModel model in models)
            {
                if (!dic.TryGetValue(model.FieldIdentifier, out ControlFieldEntity entity))
                    continue;

                if (model.Type != entity.Type)
                    continue;

                model.Value = entity.Value;
            }
        }
    }
}
