﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// GH Category 节点
    /// </summary>
    public class GH_Category_Node : IXmlSerialize
    {
        /// <summary>
        /// 命名空间
        /// </summary>
        public string scheme { get; set; }

        /// <summary>
        /// 条款
        /// <see cref="GH_Category_Term_Enums"/>
        /// </summary>
        public string term { get; set; }

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            if (element == null)
                return;

            this.scheme = element.GetAttributeValue<string>("scheme");
            this.term = element.GetAttributeValue<string>("term");
        }

        /// <summary>
        /// 转化为XElement节点
        /// </summary>
        public XElement ToXmlElement()
        {
            throw new NotSupportedException();
        }
    }
}
