﻿using DevExpress.Data;
using log4net;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 单元格编辑基类
    /// </summary>
    public abstract class ListCellEditBase : UserControl
    {
        public ListCellEditBase()
        {
            this.DataContextChanged += CellEditBase_DataContextChanged;
            this.PreviewMouseLeftButtonDown += ListCellEditBase_PreviewMouseLeftButtonDown;
        }

        /// <summary>
        /// 是否向预览发送命令
        /// </summary>
        protected bool IsSendToPreview;

        /// <summary>
        /// Viz控制对象服务
        /// </summary>
        protected VizCommandControlObjectService VizCommandControlObjectService = new VizCommandControlObjectService();

        /// <summary>
        /// 获取字段编辑窗口
        /// </summary>
        /// <returns>字段编辑窗口</returns>
        protected FieldEditWindow GetFieldEditWindow()
        {
            if (ApplicationDomainEx.FieldEditWindow == null)
            {
                ApplicationDomainEx.FieldEditWindow = new FieldEditWindow();
                ApplicationDomainEx.FieldEditWindow.Owner = ApplicationDomainEx.MainWindow;
            }

            return ApplicationDomainEx.FieldEditWindow as FieldEditWindow;
        }

        /// <summary>
        /// 数据上下文改变时触发
        /// </summary>
        /// <param name="e">事件参数</param>
        protected virtual void OnDataContextChanged(System.Windows.DependencyPropertyChangedEventArgs e)
        {

        }

        /// <summary>
        /// 数据上下文改变时触发
        /// </summary>
        private void CellEditBase_DataContextChanged(object sender, System.Windows.DependencyPropertyChangedEventArgs e)
        {
            this.OnDataContextChanged(e);
        }

        /// <summary>
        /// 鼠标点击时触发
        /// </summary>
        private void ListCellEditBase_PreviewMouseLeftButtonDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            DevExpress.Xpf.Grid.EditGridCellData cellData = this.DataContext as DevExpress.Xpf.Grid.EditGridCellData;
            if (cellData == null)
                return;

            GridColumnDefinition columnDefinition = cellData.Column.DataContext as GridColumnDefinition;
            if (columnDefinition == null)
                return;

            ControlListFieldChangedMessage msg = new ControlListFieldChangedMessage();
            msg.ControlObject = columnDefinition.ControlObject;
            msg.ControlField = columnDefinition.ControlField;
            msg.Object = cellData.Row;
            msg.ListLine = cellData.RowData.RowHandle.Value;
            msg.FieldIdentifier = columnDefinition.FieldName;

            ApplicationDomainEx.MessageManager.Send(msg);
        }

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="columnDefinition">列定义</param>
        /// <param name="rowHandle">行号</param>
        /// <param name="row">行数据</param>
        public virtual void UpdateEditValue(GridColumnDefinition columnDefinition, int rowHandle, ExpandoObject row)
        {

        }
    }
}
