﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 资源编辑面板模型基类
    /// </summary>
    public abstract class ResourceEditPanelModelBase : EditPanelModelBase
    {
        public ResourceEditPanelModelBase()
        {
            // GH资源
            this.GHResourceEditPartModel = new GHResourceEditPartModel();
            this.GHResourceEditPartModel.OwnerViewModel = this;

            // 媒资库

            this.MHResourceEditPartModel = new MHResourceEditPartModel();
            this.MHResourceEditPartModel.OwnerViewModel = this;

            // 本地资源
        }

        #region GHResourceEditPartModel -- GH资源编辑部分模型

        private GHResourceEditPartModel ghResourceEditPartModel;
        /// <summary>
        /// GH资源编辑部分模型
        /// </summary>
        public GHResourceEditPartModel GHResourceEditPartModel
        {
            get { return ghResourceEditPartModel; }
            set { ghResourceEditPartModel = value; this.RaisePropertyChanged(nameof(GHResourceEditPartModel)); }
        }

        /// <summary>
        /// 媒体库部分编辑
        /// </summary>

        private MHResourceEditPartModel mhResourceEditPartModel;


        public MHResourceEditPartModel MHResourceEditPartModel
        {
            get { return mhResourceEditPartModel; }
            set { mhResourceEditPartModel = value; this.RaisePropertyChanged(nameof(MHResourceEditPartModel)); }
        }

        #endregion
    }
}
