﻿using DevExpress.Mvvm.POCO;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Common;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 字段编辑视图模型
    /// </summary>
    public abstract class FieldEditViewModelBase : ViewModelBase
    {
        /// <summary>
        /// 字段编辑视图模型
        /// </summary>
        public FieldEditViewModelBase()
        {
            // 初始化导航配置
            this.InitNavigationConfigs();
        }

        /// <summary>
        /// 初始化导航配置
        /// </summary>
        private void InitNavigationConfigs()
        {
            // 文本编辑器
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.text.ToString(),
                ViewType = typeof(TextEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 富文本编辑器
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.richtext.ToString(),
                ViewType = typeof(RichTextEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // Boolean类型
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.boolean.ToString(),
                ViewType = typeof(BooleanEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 图片选择
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.image.ToString(),
                ViewType = typeof(ImageEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 列表编辑
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.list.ToString(),
                ViewType = typeof(ListEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 数字
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.integer.ToString(),
                ViewType = typeof(IntegerEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 浮点数字
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.@float.ToString(),
                ViewType = typeof(FloatEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 二元编辑
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.duplet.ToString(),
                ViewType = typeof(DupletEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 三元编辑
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.triplet.ToString(),
                ViewType = typeof(TripletEditPanel),
                ViewCreated = this.OnViewCreated
            });

        }

        // =============================================================
        // Property
        // =============================================================

        #region NavigationConfigs -- 导航配置

        private List<NavigationConfig> navigationConfigs = new List<NavigationConfig>();
        /// <summary>
        /// 导航配置
        /// </summary>
        public List<NavigationConfig> NavigationConfigs
        {
            get { return navigationConfigs; }
            set { navigationConfigs = value; this.RaisePropertyChanged(nameof(NavigationConfigs)); }
        }

        #endregion

        #region SelectedNavigationConfig -- 当前选中的导航配置

        private NavigationConfig selectedNavigationConfig;
        /// <summary>
        /// 当前选中的导航配置
        /// </summary>
        public NavigationConfig SelectedNavigationConfig
        {
            get { return selectedNavigationConfig; }
            set { selectedNavigationConfig = value; this.RaisePropertyChanged(nameof(SelectedNavigationConfig)); }
        }

        #endregion

        // =============================================================
        // Public Function
        // =============================================================

        /// <summary>
        /// 获取当前正在编辑字段的值
        /// </summary>
        /// <returns>当前正在编辑字段的值</returns>
        public string GetCurrentEditFieldValue()
        {
            if (this.SelectedNavigationConfig == null || this.SelectedNavigationConfig.View == null)
                return null;

            this.SelectedNavigationConfig.View.TryGetTarget(out object target);
            FrameworkElement view = target as FrameworkElement;
            if (view == null)
                return null;

            EditPanelModelBase vm = view.DataContext as EditPanelModelBase;
            if (vm == null)
                return null;

            return vm.GetFieldValue();
        }

        // =============================================================
        // Private Function
        // =============================================================

        /// <summary>
        /// 视图创建后触发
        /// </summary>
        /// <param name="config">导航配置</param>
        /// <param name="obj">视图</param>
        protected abstract void OnViewCreated(NavigationConfig config, object obj);
    }
}