﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 日志视图模型
    /// </summary>
    public class LogViewModel : ViewModelBase, ILogService
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(LogViewModel));

        /// <summary>
        /// 日志视图模型
        /// </summary>
        public LogViewModel()
        {
            // 初始化命令
            this.InitCommand();

            // 初始化消息
            this.InitMessage();

            /// 注册服务
            ApplicationDomainEx.ServiceManager.AddService(ViewServiceKeys.LOG_VIEW_SERVICE, this);
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.ClearCommand = new VCommand(this.Clear);
        }

        /// <summary>
        /// 初始化消息
        /// </summary>
        private void InitMessage()
        {
            ApplicationDomainEx.MessageManager.Register<LogMessage>(this, this.OnLogMessage);
        }

        // ==================================================================================
        // Command
        // ==================================================================================

        #region ClearCommand -- 清除消息

        /// <summary>
        /// 清除消息
        /// </summary>
        public VCommand ClearCommand { get; set; }

        /// <summary>
        /// 清除
        /// </summary>
        private void Clear()
        {
            this.ClearLog();
        }

        #endregion

        // ==================================================================================
        // Message
        // ==================================================================================

        /// <summary>
        /// 处理日志消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnLogMessage(LogMessage msg)
        {
            string log = $"{DateTime.Now.ToString("HH:mm:ss")} <{msg.Type}> {msg.Log}";

            this.AppendLog(log);
        }

        // ==================================================================================
        // Public Function
        // ==================================================================================

        /// <summary>
        /// 添加日志
        /// </summary>
        /// <param name="log"></param>
        public void AppendLog(string log)
        {
            WPFHelper.BeginInvoke(() =>
            {
                LogView view = this.GetView<LogView>();
                if (view == null)
                    return;

                view.tb.AppendText($"{log}\r\n");
            });
        }

        /// <summary>
        /// 清理日志
        /// </summary>
        public void ClearLog()
        {
            WPFHelper.BeginInvoke(() =>
            {
                LogView view = this.GetView<LogView>();
                if (view == null)
                    return;

                view.tb.Clear();
            });
        }
    }
}