﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// GH场景视图模型
    /// </summary>
    public class GHSceneViewModel : GHResourcePanelModel
    {
        public GHSceneViewModel()
        {
            this.FilterResourceFileType = ResourceFileType.SCENE;

            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.AddSceneTemplateCommand = new VCommand(this.AddSceneTemplate);
            this.CancelFileSelectedCommand = new VCommand(this.CancelFileSelected);
        }

        // ===========================================================================
        // Command
        // ===========================================================================

        #region AddSceneTemplateCommand -- 添加场景模板命令

        /// <summary>
        /// 添加场景模板命令
        /// </summary>
        public VCommand AddSceneTemplateCommand { get; set; }

        /// <summary>
        /// 添加场景模板
        /// </summary>
        private void AddSceneTemplate()
        {
            if (this.SelectedFolderModel == null)
                return;

            IPageTemplateService service = ApplicationDomainEx.ServiceManager.GetService<IPageTemplateService>(ViewServiceKeys.PAGE_TEMPLATE_SERVICE);
            if (service == null)
                return;

            foreach (GHResourceFileModel file in this.SelectedFolderModel.Files)
            {
                if (!file.IsChecked)
                    continue;

                service.AddSceneTemplate(file);
            }
        }

        #endregion

        #region CancelFileSelectedCommand -- 取消文件选择命令

        /// <summary>
        /// 取消文件选择命令
        /// </summary>
        public VCommand CancelFileSelectedCommand { get; set; }

        /// <summary>
        /// 取消文件选择
        /// </summary>
        private void CancelFileSelected()
        {
            if (this.SelectedFolderModel == null)
                return;

            foreach (GHResourceFileModel file in this.SelectedFolderModel.Files)
            {
                file.IsChecked = false;
            }
        }

        #endregion
    }
}
