﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    public interface IMediaResourceFileSupport
    {
        /// <summary>
        /// 文件夹目录集合
        /// </summary>
        ObservableCollection<MHResourceFolderModel> FolderModels { get; set; }

        /// <summary>
        /// 当前选中的文件夹
        /// </summary>
        MHResourceFolderModel SelectedFolderModel { get; set; }

        /// <summary>
        /// 文件集合
        /// </summary>
        ObservableCollection<MHResourceFileModel> FileModels { get; set; }

        /// <summary>
        /// 选中的文件模型
        /// </summary>
        MHResourceFileModel SelectedFileModel { get; set; }

        /// <summary>
        /// 是否正在加载文件
        /// </summary>
        bool IsFileLoading { get; set; }
    }
}
