﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    /// <summary>
    /// Interaction logic for MediaResourcePanel.xaml
    /// </summary>
    public partial class MediaResourcePanel : UserControl
    {
        public MediaResourcePanel()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this, new MediaResourcePanelViewModel());

        }

        #region FolderContextMenu -- 文件夹右键菜单

        /// <summary>
        /// 文件夹右键菜单
        /// </summary>
        public ContextMenu FolderContextMenu
        {
            get { return (ContextMenu)GetValue(FolderContextMenuProperty); }
            set { SetValue(FolderContextMenuProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for FolderContextMenu.  This enables animation, styling, binding, etc... 
        /// </summary>
        public static readonly DependencyProperty FolderContextMenuProperty =
            DependencyProperty.Register("FolderContextMenu", typeof(ContextMenu), typeof(MediaResourcePanel), new PropertyMetadata(null));

        #endregion

        #region FileContextMenu -- 文件右键菜单

        /// <summary>
        /// 文件右键菜单
        /// </summary>
        public ContextMenu FileContextMenu
        {
            get { return (ContextMenu)GetValue(FileContextMenuProperty); }
            set { SetValue(FileContextMenuProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for FileContextMenu.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty FileContextMenuProperty =
            DependencyProperty.Register("FileContextMenu", typeof(ContextMenu), typeof(MediaResourcePanel), new PropertyMetadata(null));

        #endregion


    }
}
