﻿using DevExpress.Xpf.Core;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using VIZ.Framework.Module;
using VIZ.Package.Domain;

namespace VIZ.Package
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : ThemedWindow
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(MainWindow));

        public MainWindow()
        {
            InitializeComponent();

            this.Closing += MainWindow_Closing;
            this.Closed += MainWindow_Closed;
        }

        /// <summary>
        /// 关闭窗口前触发
        /// </summary>
        private void MainWindow_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            // 发送系统关闭消息
            try
            {
                ApplicationCloseMessage msg = new ApplicationCloseMessage();
                ApplicationDomainEx.MessageManager.Send(msg);
            }
            catch (Exception ex)
            {
                log.Error(ex);
            }
        }

        /// <summary>
        /// 关闭窗口
        /// </summary>
        private void MainWindow_Closed(object sender, EventArgs e)
        {
            // 启动结束流程
            AppSetup.ShutDown();

            // 结束进程
            Environment.Exit(0);
        }
    }
}
