﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 插件映射
    /// </summary>
    public class PluginMapping
    {
        /// <summary>
        /// 场景
        /// </summary>
        public string Scene { get; set; }

        /// <summary>
        /// 插件ID
        /// </summary>
        public string PluginID { get; set; }
    }

    /// <summary>
    /// 插件映射配置
    /// </summary>
    public class PluginMappingConfigEntity
    {
        /// <summary>
        /// 编号
        /// </summary>
        [BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// 插件分组
        /// </summary>
        public string PluginGroup { get; set; }

        /// <summary>
        /// 映射集合
        /// </summary>
        public List<PluginMapping> Mappings { get; set; }
    }
}
