﻿using DevExpress.Xpf.Core;
using DevExpress.Xpf.Core.DragAndDrop;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls.Primitives;
using System.Windows.Media;
using VIZ.Framework.Module;
using VIZ.Package.Common;
using VIZ.Package.Domain;
using VIZ.Package.Module;
using VIZ.Package.Module.Resource;

namespace VIZ.Package
{
    /// <summary>
    /// App.xaml 的交互逻辑
    /// </summary>
    public partial class App : Application
    {
        public App()
        {
            // 设置DevExpress主题
            //VizThemeThemePalette palette = new VizThemeThemePalette();
            //Theme theme = Theme.CreateTheme(palette, Theme.Win11Dark);
            //Theme.RegisterTheme(theme);
            //ApplicationThemeHelper.ApplicationThemeName = theme.Name;
            ApplicationThemeHelper.ApplicationThemeName = Theme.Win10DarkName;

            // 初始化LiteDB
            AppSetup.AppendSetup(new AppSetup_InitLiteDB());

            // 执行启动流程
            AppSetupContext context = AppSetup.Setup();

            if (context.Exception != null)
            {
                MessageBox.Show($"执行 {context.ProviderDetail} 失败\r\n{context.Exception.Message}");
            }

            if (!context.IsSuccess)
            {
                Environment.Exit(-1);
            }

            // 初始化窗口
            ApplicationDomainEx.LoginWindow = new LoginWindow();
            ApplicationDomainEx.MainWindowType = typeof(MainWindow);
            ApplicationDomainEx.LoginWindow.Show();

            // 调试窗口
            if (ApplicationDomainEx.IS_DEBUG)
            {
                DebugWindow debugWindow = new DebugWindow();
                debugWindow.Show();
                debugWindow.Topmost = true;
            }
        }
    }
}
