﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using System.Windows;
using VIZ.Framework.Domain;
using VIZ.Package.Plugin;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 应用程序域
    /// </summary>
    public class ApplicationDomainEx : ApplicationDomain
    {
        // =============================================================
        // 窗口
        // =============================================================

        /// <summary>
        /// 登录窗口
        /// </summary>
        public static Window LoginWindow { get; set; }

        /// <summary>
        /// 主窗口
        /// </summary>
        public static Window MainWindow { get; set; }

        /// <summary>
        /// 主窗口类型
        /// </summary>
        public static Type MainWindowType { get; set; }

        /// <summary>
        /// 字段编辑窗口
        /// </summary>
        public static Window FieldEditWindow { get; set; }

        // =============================================================
        // 数据
        // =============================================================

        /// <summary>
        /// 本地数据
        /// </summary>
        public static LocalDbContext LocalDbContext { get; set; }

        /// <summary>
        /// 项目数据
        /// </summary>
        public static ProjectDbContext ProjectDbContext { get; set; }

        // =============================================================
        // 配置
        // =============================================================

        /// <summary>
        /// Viz配置
        /// </summary>
        public static VizConfigEntity VizConfig { get; set; }

        /// <summary>
        /// 插件信息
        /// </summary>
        public static List<PluginInfo> PluginInfos { get; set; }

        // =============================================================
        // 其他
        // =============================================================

        /// <summary>
        /// 预览连接
        /// </summary>
        public static ConnModel PreviewConn { get; set; }

        /// <summary>
        /// Viz预览进程
        /// </summary>
        public static Process VizPreviewProcess { get; set; }

        /// <summary>
        /// Viz预览渲染器名称
        /// </summary>
        public static string VizPreviewRenderer { get; set; }

        /// <summary>
        /// 当前页
        /// </summary>
        public static PageModelBase CurrentPage { get; set; }
    }
}
