﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 列定义
    /// </summary>
    public class GridColumnDefinition
    {
        /// <summary>
        /// 绑定字段
        /// </summary>
        public string FieldName { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public GridColumnWidth Width { get; set; } = new GridColumnWidth(1, GridColumnUnitType.Star);

        /// <summary>
        /// 最小宽度
        /// </summary>
        public double MinWidth { get; set; } = 120;

        /// <summary>
        /// 头部
        /// </summary>
        public object Header { get; set; }

        /// <summary>
        /// 是否只读
        /// </summary>
        public bool ReadOnly { get; set; }

        /// <summary>
        /// 是否启用编辑
        /// </summary>
        public bool AllowEditing { get; set; }

        /// <summary>
        /// 字段类型
        /// </summary>
        public VizControlFieldType Type { get; set; }

        /// <summary>
        /// 控制对象
        /// </summary>
        public ControlObjectModel ControlObject { get; set; }

        /// <summary>
        /// 控制字段
        /// </summary>
        public ControlFieldNodeModel ControlField { get; set; }
    }
}
