﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Connection;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 包装终结点管理器
    /// </summary>
    public interface IPackageEndpointManager : IDisposable
    {
        /// <summary>
        /// 连接状态改变事件参数
        /// </summary>
        event EventHandler<ConnectionStateChangedEventArgs> ConnectionStateChanged;

        /// <summary>
        /// 连接
        /// </summary>
        bool Connect();

        /// <summary>
        /// 断开连接
        /// </summary>
        void Disconnect();

        /// <summary>
        /// 发送消息
        /// </summary>
        /// <param name="message">消息</param>
        void Send(string message);

        /// <summary>
        /// 请求返回
        /// </summary>
        /// <param name="message">消息</param>
        /// <returns>返回值</returns>
        string Request(string message);
    }
}
