﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 编辑面板模型基类
    /// </summary>
    public abstract class EditPanelModelBase : ViewModelBase
    {

        // ============================================================
        // Service & Controller
        // ============================================================

        /// <summary>
        /// Viz 控制对象服务
        /// </summary>
        protected VizCommandControlObjectService VizCommandControlObjectService = new VizCommandControlObjectService();

        // ============================================================
        // Property
        // ============================================================

        #region IsSendToPreview -- 是否向预览发送命令

        private bool isSendToPreview;
        /// <summary>
        /// 是否向预览发送命令
        /// </summary>
        public bool IsSendToPreview
        {
            get { return isSendToPreview; }
            set { isSendToPreview = value; this.RaisePropertyChanged(nameof(IsSendToPreview)); }
        }

        #endregion

        #region FieldEditMode -- 字段编辑模式

        private FieldEditMode fieldEditMode;
        /// <summary>
        /// 字段编辑模式
        /// </summary>
        public FieldEditMode FieldEditMode
        {
            get { return fieldEditMode; }
            set { fieldEditMode = value; this.RaisePropertyChanged(nameof(FieldEditMode)); }
        }

        #endregion

        #region ControlObject -- 控制对象

        private ControlObjectModel controlObject;
        /// <summary>
        /// 控制对象
        /// </summary>
        public ControlObjectModel ControlObject
        {
            get { return controlObject; }
            set { controlObject = value; this.RaisePropertyChanged(nameof(ControlObject)); }
        }

        #endregion

        #region ControlField -- 所属控制字段

        private ControlFieldNodeModel controlField;
        /// <summary>
        /// 所属控制字段
        /// </summary>
        public ControlFieldNodeModel ControlField
        {
            get { return controlField; }
            set { controlField = value; this.RaisePropertyChanged(nameof(ControlField)); }
        }

        #endregion

        #region ColumnDefinition -- 列定义

        private GridColumnDefinition columnDefinition;
        /// <summary>
        /// 列定义
        /// </summary>
        public GridColumnDefinition ColumnDefinition
        {
            get { return columnDefinition; }
            set { columnDefinition = value; this.RaisePropertyChanged(nameof(ColumnDefinition)); }
        }

        #endregion

        #region RowHandle -- 行和号

        private int rowHandle;
        /// <summary>
        /// 行号
        /// </summary>
        public int RowHandle
        {
            get { return rowHandle; }
            set { rowHandle = value; this.RaisePropertyChanged(nameof(RowHandle)); }
        }

        #endregion

        #region Row -- 行数据

        private ExpandoObject row;
        /// <summary>
        /// 行数据
        /// </summary>
        public ExpandoObject Row
        {
            get { return row; }
            set { row = value; this.RaisePropertyChanged(nameof(Row)); }
        }

        #endregion

        #region ListCellEdit -- 单元格编辑控件

        private ListCellEditBase listCellEdit;
        /// <summary>
        /// 单元格编辑控件
        /// </summary>
        public ListCellEditBase ListCellEdit
        {
            get { return listCellEdit; }
            set { listCellEdit = value; this.RaisePropertyChanged(nameof(ListCellEdit)); }
        }

        #endregion

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="controlObject">控制对象</param>
        /// <param name="controlField">控制字段</param>
        public virtual void Update(ControlObjectModel controlObject, ControlFieldNodeModel controlField)
        {
            this.ControlObject = controlObject;
            this.ControlField = controlField;

            this.IsSendToPreview = true;
        }

        /// <summary>
        /// 更新动态数据
        /// </summary>
        /// <param name="listCellEdit">列单元格编辑器</param>
        /// <param name="columnDefinition">列定义</param>
        /// <param name="rowHandle">行号</param>
        /// <param name="row">行数据</param>
        public virtual void UpdateDynamic(ListCellEditBase listCellEdit, GridColumnDefinition columnDefinition, int rowHandle, ExpandoObject row)
        {
            this.ListCellEdit = listCellEdit;
            this.ControlObject = columnDefinition.ControlObject;
            this.ControlField = columnDefinition.ControlField;
            this.ColumnDefinition = columnDefinition;
            this.RowHandle = rowHandle;
            this.Row = row;

            this.IsSendToPreview = true;
        }
    }
}
