﻿using DevExpress.Mvvm.POCO;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Common;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 字段编辑窗口视图模型
    /// </summary>
    public class FieldEditWindowModel : ViewModelBase
    {
        public FieldEditWindowModel()
        {
            // 初始化导航配置
            this.InitNavigationConfigs();
        }

        /// <summary>
        /// 初始化导航配置
        /// </summary>
        private void InitNavigationConfigs()
        {
            // 文本编辑器
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.text.ToString(),
                ViewType = typeof(TextEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 图片选择
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.image.ToString(),
                ViewType = typeof(ImageEditPanel),
                ViewCreated = this.OnViewCreated
            });

            // 列表编辑
            this.NavigationConfigs.Add(new NavigationConfig
            {
                Key = VizControlFieldType.list.ToString(),
                ViewType = typeof(ListEditPanel),
                ViewCreated = this.OnViewCreated
            });
        }

        // =============================================================
        // Property
        // =============================================================

        #region NavigationConfigs -- 导航配置

        private List<NavigationConfig> navigationConfigs = new List<NavigationConfig>();
        /// <summary>
        /// 导航配置
        /// </summary>
        public List<NavigationConfig> NavigationConfigs
        {
            get { return navigationConfigs; }
            set { navigationConfigs = value; this.RaisePropertyChanged(nameof(NavigationConfigs)); }
        }

        #endregion

        #region SelectedNavigationConfig -- 当前选中的导航配置

        private NavigationConfig selectedNavigationConfig;
        /// <summary>
        /// 当前选中的导航配置
        /// </summary>
        public NavigationConfig SelectedNavigationConfig
        {
            get { return selectedNavigationConfig; }
            set { selectedNavigationConfig = value; this.RaisePropertyChanged(nameof(SelectedNavigationConfig)); }
        }

        #endregion

        #region ColumnDefinition -- 列定义

        private GridColumnDefinition columnDefinition;
        /// <summary>
        /// 列定义
        /// </summary>
        public GridColumnDefinition ColumnDefinition
        {
            get { return columnDefinition; }
            set { columnDefinition = value; this.RaisePropertyChanged(nameof(ColumnDefinition)); }
        }

        #endregion

        #region RowHandle -- 行号

        private int rowHandle;
        /// <summary>
        /// 行号
        /// </summary>
        public int RowHandle
        {
            get { return rowHandle; }
            set { rowHandle = value; this.RaisePropertyChanged(nameof(RowHandle)); }
        }

        #endregion

        #region Row -- 行数据

        private ExpandoObject row;
        /// <summary>
        /// 行数据
        /// </summary>
        public ExpandoObject Row
        {
            get { return row; }
            set { row = value; this.RaisePropertyChanged(nameof(Row)); }
        }

        #endregion

        #region ListCellEdit -- 单元格编辑控件

        private ListCellEditBase listCellEdit;
        /// <summary>
        /// 单元格编辑控件
        /// </summary>
        public ListCellEditBase ListCellEdit
        {
            get { return listCellEdit; }
            set { listCellEdit = value; this.RaisePropertyChanged(nameof(ListCellEdit)); }
        }

        #endregion

        // =============================================================
        // Public Function
        // =============================================================

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="listCellEdit">列表单元格编辑控件</param>
        /// <param name="columnDefinition">列定义</param>
        /// <param name="rowHandle">行号</param>
        /// <param name="row">行数据</param>
        public void Update(ListCellEditBase listCellEdit, GridColumnDefinition columnDefinition, int rowHandle, ExpandoObject row)
        {
            this.ListCellEdit = listCellEdit;
            this.ColumnDefinition = columnDefinition;
            this.RowHandle = rowHandle;
            this.Row = row;

            if (this.ColumnDefinition == null || this.ColumnDefinition.ControlObject == null || this.ColumnDefinition.ControlField == null)
            {
                this.SelectedNavigationConfig = null;
                return;
            }

            NavigationConfig config = this.NavigationConfigs.FirstOrDefault(p => p.Key == this.ColumnDefinition.Type.ToString());

            if (config != null && config.View != null && config.View.TryGetTarget(out object target))
            {
                FrameworkElement view = target as FrameworkElement;
                EditPanelModelBase model = view?.DataContext as EditPanelModelBase;

                if (model != null)
                {
                    model.FieldEditMode = FieldEditMode.Dynamic;
                    model.UpdateDynamic(this.ListCellEdit, this.ColumnDefinition, this.RowHandle, this.Row);
                }
            }

            this.SelectedNavigationConfig = config;
        }

        // =============================================================
        // Private Function
        // =============================================================

        /// <summary>
        /// 视图创建后触发
        /// </summary>
        /// <param name="config">导航配置</param>
        /// <param name="obj">视图</param>
        private void OnViewCreated(NavigationConfig config, object obj)
        {
            FrameworkElement view = obj as FrameworkElement;
            if (view == null)
                return;

            EditPanelModelBase model = view.DataContext as EditPanelModelBase;
            if (model == null)
                return;

            model.FieldEditMode = FieldEditMode.Dynamic;
            model.UpdateDynamic(this.ListCellEdit, this.ColumnDefinition, this.RowHandle, this.Row);
        }
    }
}