﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 调试视图模型
    /// </summary>
    public class DebugViewModel : ViewModelBase
    {
        public DebugViewModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初试化命令
        /// </summary>
        private void InitCommand()
        {
            // Docking
            this.SaveLayoutCommand = new VCommand(this.SaveLayout);
            this.LoadLayoutCommand = new VCommand(this.LoadLayout);

            // 日志
            this.AddLogCommand = new VCommand(this.AddLog);
            this.ClearLogCommand = new VCommand(this.ClearLog);
        }

        // ======================================================================
        // Command
        // ======================================================================

        // ---------------------------------------------------------
        // Docking

        #region SaveLayoutCommand -- 保存布局命令

        /// <summary>
        /// 保存布局命令
        /// </summary>
        public VCommand SaveLayoutCommand { get; set; }

        /// <summary>
        /// 保存布局
        /// </summary>
        private void SaveLayout()
        {
            IMainViewService service = ApplicationDomainEx.ServiceManager.GetService<IMainViewService>(ViewServiceKeys.MAIN_VIEW_SERVICE);
            if (service == null)
                return;

            service.SaveLayout();
        }

        #endregion

        #region LoadLayoutCommand -- 加载布局命令

        /// <summary>
        /// 加载布局命令
        /// </summary>
        public VCommand LoadLayoutCommand { get; set; }

        /// <summary>
        /// 加载布局
        /// </summary>
        private void LoadLayout()
        {
            IMainViewService service = ApplicationDomainEx.ServiceManager.GetService<IMainViewService>(ViewServiceKeys.MAIN_VIEW_SERVICE);
            if (service == null)
                return;

            service.LoadLayout();
        }

        #endregion

        // ---------------------------------------------------------
        // 日志

        #region AddLogCommand -- 添加日志命令

        /// <summary>
        /// 添加日志命令
        /// </summary>
        public VCommand AddLogCommand { get; set; }

        /// <summary>
        /// 添加日志
        /// </summary>
        private void AddLog()
        {
            ILogService service = ApplicationDomainEx.ServiceManager.GetService<ILogService>(ViewServiceKeys.LOG_VIEW_SERVICE);
            if (service == null)
                return;

            service.AppendLog("this is a try.");
        }

        #endregion

        #region ClearLogCommand -- 清理日志命令

        /// <summary>
        /// 清理日志命令
        /// </summary>
        public VCommand ClearLogCommand { get; set; }

        /// <summary>
        /// 清理日志
        /// </summary>
        private void ClearLog()
        {
            ILogService service = ApplicationDomainEx.ServiceManager.GetService<ILogService>(ViewServiceKeys.LOG_VIEW_SERVICE);
            if (service == null)
                return;

            service.ClearLog();
        }

        #endregion
    }
}
