﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;
using VIZ.Package.Plugin;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 页模板插件生命周期
    /// </summary>
    public class PageGroupPluginLifeCycle : IPluginLifeCycle
    {
        /// <summary>
        /// 插件ID
        /// </summary>
        /// <remarks>
        /// 插件ID不能包含点号
        /// </remarks>
        public const string PLUGIN_ID = ModulePluginIds.PAGE_GROUP;

        /// <summary>
        /// 插件名称
        /// </summary>
        public const string PLUGIN_NAME = "节目单";

        /// <summary>
        /// 注册
        /// </summary>
        /// <returns>插件信息</returns>
        public PluginInfo Register()
        {
            PluginInfo info = new PluginInfo();
            info.ID = PLUGIN_ID;
            info.Name = PLUGIN_NAME;
            info.ViewType = typeof(PageGroupView);

            return info;
        }

        /// <summary>
        /// 初始化
        /// </summary>
        public void Initialize()
        {

        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {

        }
    }
}
