﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Service
{
    /// <summary>
    /// 页服务
    /// </summary>
    public class PageService
    {
        /// <summary>
        /// 加载页模板集合
        /// </summary>
        /// <returns>节目模板集合</returns>
        public IList<PageTemplateModel> LoadPageTemplates()
        {
            List<PageTemplateModel> list = new List<PageTemplateModel>();

            foreach (var entity in ApplicationDomainEx.ProjectDbContext.PageTemplate.FindAll())
            {
                PageTemplateModel model = new PageTemplateModel();

                model.Scene = entity.Scene;
                model.ScenePath = entity.ScenePath;
                model.ThumbnailUri = entity.ThumbnailUri;
                model.Remark = entity.Remark;
                model.Layer = entity.Layer;
                model.EngineType = entity.EngineType;
                model.PageType = entity.PageType;
                model.Order = entity.Order;
                model.TemplateID = entity.TemplateID;

                list.Add(model);
            }

            return list.OrderBy(p => p.Order).ToList();
        }

        /// <summary>
        /// 保存页模板集合
        /// </summary>
        /// <param name="pageTemplates">页模板集合</param>
        public void SavePageTemplates(IList<PageTemplateModel> pageTemplates)
        {
            ApplicationDomainEx.ProjectDbContext.PageTemplate.DeleteAll();

            List<PageTemplateEntity> list = new List<PageTemplateEntity>();

            for (int i = 0; i < pageTemplates.Count; i++)
            {
                PageTemplateModel model = pageTemplates[i];
                PageTemplateEntity entity = new PageTemplateEntity();

                entity.Scene = model.Scene;
                entity.ScenePath = model.ScenePath;
                entity.ThumbnailUri = model.ThumbnailUri;
                entity.Remark = model.Remark;
                entity.Layer = model.Layer;
                entity.EngineType = model.EngineType;
                entity.PageType = model.PageType;
                entity.Order = model.Order;
                entity.TemplateID = model.TemplateID;
                entity.Order = i;

                list.Add(entity);
            }

            ApplicationDomainEx.ProjectDbContext.PageTemplate.Insert(list);
        }

        /// <summary>
        /// 加载页分组集合
        /// </summary>
        /// <returns>页分组集合</returns>
        public IList<PageGroupModel> LoadPageGroups()
        {
            Dictionary<Guid, PageGroupModel> dic = new Dictionary<Guid, PageGroupModel>();

            // 页分组
            foreach (var entity in ApplicationDomainEx.ProjectDbContext.PageGroup.FindAll())
            {
                PageGroupModel model = new PageGroupModel();

                model.GroupID = entity.GroupID;
                model.GroupName = entity.GroupName;
                model.Order = entity.Order;

                dic[model.GroupID] = model;
            }

            // 页
            foreach (var entity in ApplicationDomainEx.ProjectDbContext.Page.FindAll())
            {
                if (!dic.TryGetValue(entity.PageGroupID, out PageGroupModel groupModel))
                    continue;

                PageModel model = new PageModel();

                model.Scene = entity.Scene;
                model.ScenePath = entity.ScenePath;
                model.ThumbnailUri = entity.ThumbnailUri;
                model.Remark = entity.Remark;
                model.Layer = entity.Layer;
                model.EngineType = entity.EngineType;
                model.PageType = entity.PageType;
                model.Order = entity.Order;
                model.TemplateID = entity.TemplateID;
                model.PageID = entity.PageID;
                model.PageGroupID = entity.PageGroupID;
                model.TemplateID = entity.TemplateID;
                model.PluginID = entity.PluginID;
                model.Order = entity.Order;

                groupModel.Pages.Add(model);
            }

            // 页分组排序
            foreach (var kv in dic)
            {
                kv.Value.Pages = kv.Value.Pages.OrderBy(p => p.Order).ToObservableCollection();
            }

            return dic.Values.OrderBy(p => p.Order).ToList();
        }

        /// <summary>
        /// 保存页分组集合
        /// </summary>
        /// <param name="pageGroups">页分组集合</param>
        public void SavePageGroups(IList<PageGroupModel> pageGroups)
        {
            List<PageGroupEntity> groups = new List<PageGroupEntity>();
            List<PageEntity> pages = new List<PageEntity>();

            for (int i = 0; i < pageGroups.Count; i++)
            {
                PageGroupModel groupModel = pageGroups[i];

                // 分组
                PageGroupEntity groupEntity = new PageGroupEntity();

                groupEntity.GroupID = groupModel.GroupID;
                groupEntity.GroupName = groupModel.GroupName;
                groupEntity.Order = i;

                groups.Add(groupEntity);

                // 页
                for (int j = 0; j < groupModel.Pages.Count; j++)
                {
                    PageModel pageModel = groupModel.Pages[j];

                    PageEntity pageEntity = new PageEntity();

                    pageEntity.Scene = pageModel.Scene;
                    pageEntity.ScenePath = pageModel.ScenePath;
                    pageEntity.ThumbnailUri = pageModel.ThumbnailUri;
                    pageEntity.Remark = pageModel.Remark;
                    pageEntity.Layer = pageModel.Layer;
                    pageEntity.EngineType = pageModel.EngineType;
                    pageEntity.PageType = pageModel.PageType;
                    pageEntity.Order = pageModel.Order;
                    pageEntity.TemplateID = pageModel.TemplateID;
                    pageEntity.PageID = pageModel.PageID;
                    pageEntity.PageGroupID = pageModel.PageGroupID;
                    pageEntity.TemplateID = pageModel.TemplateID;
                    pageEntity.PluginID = pageModel.PluginID;
                    pageEntity.Order = j;

                    pages.Add(pageEntity);
                }
            }

            ApplicationDomainEx.ProjectDbContext.PageGroup.DeleteAll();
            ApplicationDomainEx.ProjectDbContext.Page.DeleteAll();

            ApplicationDomainEx.ProjectDbContext.PageGroup.Insert(groups);
            ApplicationDomainEx.ProjectDbContext.Page.Insert(pages);
        }
    }
}
