﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 连接分组模型
    /// </summary>
    public class ConnGroupModel : ModelBase
    {
        #region GroupID -- 分组ID

        private Guid groupID;
        /// <summary>
        /// 分组ID
        /// </summary>
        public Guid GroupID
        {
            get { return groupID; }
            set { groupID = value; this.RaisePropertyChanged(nameof(GroupID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region IsEnabled -- 是否启用

        private bool isEnabled;
        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled
        {
            get { return isEnabled; }
            set { isEnabled = value; this.RaisePropertyChanged(nameof(IsEnabled)); }
        }

        #endregion

        #region EngineType -- 引擎类型

        private EngineType engineType;
        /// <summary>
        /// 引擎类型
        /// </summary>
        public EngineType EngineType
        {
            get { return engineType; }
            set { engineType = value; this.RaisePropertyChanged(nameof(EngineType)); }
        }


        #endregion

        #region Items -- 连接项集合

        private ObservableCollection<ConnModel> items = new ObservableCollection<ConnModel>();
        /// <summary>
        /// 连接项集合
        /// </summary>
        public ObservableCollection<ConnModel> Items
        {
            get { return items; }
            set { items = value; this.RaisePropertyChanged(nameof(Items)); }
        }

        #endregion
    }
}
