﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 连接模型
    /// </summary>
    public class ConnModel : ModelBase, IDisposable
    {
        #region ConnID -- 连接ID

        private Guid connID;
        /// <summary>
        /// 连接ID
        /// </summary>
        public Guid ConnID
        {
            get { return connID; }
            set { connID = value; this.RaisePropertyChanged(nameof(ConnID)); }
        }

        #endregion

        #region GroupID -- 分组ID

        private Guid groupID;
        /// <summary>
        /// 分组ID
        /// </summary>
        public Guid GroupID
        {
            get { return groupID; }
            set { groupID = value; this.RaisePropertyChanged(nameof(GroupID)); }
        }

        #endregion

        #region IP -- IP地址

        private string ip;
        /// <summary>
        /// IP地址
        /// </summary>
        public string IP
        {
            get { return ip; }
            set { ip = value; this.RaisePropertyChanged(nameof(IP)); }
        }

        #endregion

        #region Port -- 端口

        private int port;
        /// <summary>
        /// 端口
        /// </summary>
        public int Port
        {
            get { return port; }
            set { port = value; this.RaisePropertyChanged(nameof(Port)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region EngineType -- 引擎类型

        private EngineType engineType;
        /// <summary>
        /// 引擎类型
        /// </summary>
        public EngineType EngineType
        {
            get { return engineType; }
            set { engineType = value; this.RaisePropertyChanged(nameof(EngineType)); }
        }

        #endregion

        #region IsEnabled -- 是否启用

        private bool isEnabled;
        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled
        {
            get { return isEnabled; }
            set { isEnabled = value; this.RaisePropertyChanged(nameof(IsEnabled)); }
        }

        #endregion

        #region IsConnected -- 是否处于连接状态

        private bool isConnected;
        /// <summary>
        /// 是否处于连接状态
        /// </summary>
        public bool IsConnected
        {
            get { return isConnected; }
            set { isConnected = value; this.RaisePropertyChanged(nameof(IsConnected)); }
        }

        #endregion

        // ============================================================================

        #region IsLoading -- 是否正在等待

        private bool isLoading;
        /// <summary>
        /// 是否正在等待
        /// </summary>
        public bool IsLoading
        {
            get { return isLoading; }
            set { isLoading = value; this.RaisePropertyChanged(nameof(IsLoading)); }
        }

        #endregion

        /// <summary>
        /// 连接终结点
        /// </summary>
        public IPackageEndpointManager EndpointManager { get; private set; }

        /// <summary>
        /// 初始化终结点管理器
        /// </summary>
        /// <param name="endpointManager">终结点管理器</param>
        public void InitEndpointManager(IPackageEndpointManager endpointManager)
        {
            if (this.EndpointManager != null)
            {
                this.EndpointManager.ConnectionStateChanged -= EndpointManager_ConnectionStateChanged;
            }

            this.EndpointManager = endpointManager;
            this.EndpointManager.ConnectionStateChanged -= EndpointManager_ConnectionStateChanged;
            this.EndpointManager.ConnectionStateChanged += EndpointManager_ConnectionStateChanged;
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.EndpointManager?.Dispose();
            this.EndpointManager = null;
        }

        /// <summary>
        /// 终结点连接状态改变时触发
        /// </summary>
        private void EndpointManager_ConnectionStateChanged(object sender, Framework.Connection.ConnectionStateChangedEventArgs e)
        {
            WPFHelper.BeginInvoke(() =>
            {
                this.IsConnected = e.IsConnected;
            });
        }
    }
}
