﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 资源文件夹模型
    /// </summary>
    public abstract class ResourceFolderModelBase : ModelBase
    {
        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region FolderType -- 文件夹类型

        private ResourceFolderType folderType;
        /// <summary>
        /// 文件夹类型
        /// </summary>
        public ResourceFolderType FolderType
        {
            get { return folderType; }
            set { folderType = value; this.RaisePropertyChanged(nameof(FolderType)); }
        }

        #endregion

        #region Parent -- 父节点

        private ResourceFolderModelBase parent;
        /// <summary>
        /// 父节点
        /// </summary>
        public ResourceFolderModelBase Parent
        {
            get { return parent; }
            set { parent = value; this.RaisePropertyChanged(nameof(Parent)); }
        }

        #endregion

        #region Children -- 子节点集合

        private ObservableCollection<ResourceFolderModelBase> children = new ObservableCollection<ResourceFolderModelBase>();
        /// <summary>
        /// 子节点集合
        /// </summary>
        public ObservableCollection<ResourceFolderModelBase> Children
        {
            get { return children; }
            set { children = value; this.RaisePropertyChanged(nameof(Children)); }
        }

        #endregion

        #region IsRefreshedFiles -- 是否刷新过文件

        private bool isRefreshedFiles;
        /// <summary>
        /// 是否刷新过文件
        /// </summary>
        public bool IsRefreshedFiles
        {
            get { return isRefreshedFiles; }
            set { isRefreshedFiles = value; this.RaisePropertyChanged(nameof(IsRefreshedFiles)); }
        }

        #endregion

        #region IsExpand -- 是否展开

        private bool isExpand;
        /// <summary>
        /// 是否展开
        /// </summary>
        public bool IsExpand
        {
            get { return isExpand; }
            set { isExpand = value; this.RaisePropertyChanged(nameof(IsExpand)); }
        }

        #endregion
    }
}
