﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;
using VIZ.Package.Domain;

namespace VIZ.Package.Module.Resource
{
    /// <summary>
    /// 资源文件选择模式转化器
    /// </summary>
    public class ResourceFileSelectionModeConverter : IValueConverter
    {
        /// <summary>
        /// 单选模式数据模板
        /// </summary>
        public DataTemplate SingleDataTemplate { get; set; }

        /// <summary>
        /// 多选模式数据模板
        /// </summary>
        public DataTemplate MultipleDataTemplate { get; set; }

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (!(value is ResourceFileSelectionMode mode))
                return null;

            switch (mode)
            {
                case ResourceFileSelectionMode.Single: return this.SingleDataTemplate;
                case ResourceFileSelectionMode.Multiple: return this.MultipleDataTemplate;
                default: return null;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
