﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 列表编辑面板模型
    /// </summary>
    public class ListEditPanelModel : EditPanelModelBase
    {
        // ===================================================================
        // Service & Controller
        // ===================================================================

        /// <summary>
        /// 控制对象服务
        /// </summary>
        private VizCommandControlObjectService vizCommandControlObjectService = new VizCommandControlObjectService();

        // ===================================================================
        // Property
        // ===================================================================

        #region ItemsSource -- 数据源

        private List<ExpandoObject> itemsSource;
        /// <summary>
        /// 数据源
        /// </summary>
        public List<ExpandoObject> ItemsSource
        {
            get { return itemsSource; }
            set { itemsSource = value; this.RaisePropertyChanged(nameof(ItemsSource)); }
        }

        #endregion

        #region Columns -- 列信息

        private List<GridColumnDefinition> columns;
        /// <summary>
        /// 列信息
        /// </summary>
        public List<GridColumnDefinition> Columns
        {
            get { return columns; }
            set { columns = value; this.RaisePropertyChanged(nameof(Columns)); }
        }

        #endregion

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="controlObject">控制对象</param>
        /// <param name="controlField">控制字段</param>
        public override void Update(ControlObjectModel controlObject, ControlFieldNodeModel controlField)
        {
            base.Update(controlObject, controlField);

            this.ItemsSource = null;
            this.Columns = null;

            if (controlField == null)
                return;

            List<GridColumnDefinition> columns = this.vizCommandControlObjectService.GetControlObjectListColumn(controlField.TypeSchema);
            List<ExpandoObject> items = this.vizCommandControlObjectService.GetControlObjectListData(controlField.Value);
            foreach (GridColumnDefinition column in columns)
            {
                column.ControlObject = this.ControlObject;
                column.ControlField = this.ControlField;
            }

            this.Columns = columns;
            this.ItemsSource = items;
        }

        /// <summary>
        /// 获取字段值
        /// </summary>
        /// <returns>字段值</returns>
        public override string GetFieldValue()
        {
            return this.vizCommandControlObjectService.GetControlObjectXml(this.ItemsSource);
        }
    }
}
