﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 状态视图模型
    /// </summary>
    public class MainStatusViewModel : ViewModelBase
    {
        /// <summary>
        /// 状态视图模型
        /// </summary>
        public MainStatusViewModel()
        {
            ApplicationDomainEx.MessageManager.Register<ProjectOpenMessage>(this, this.OnProjectOpenMessage);
            ApplicationDomainEx.MessageManager.Register<ProjectCloseMessage>(this, this.OnProjectCloseMessage);
            ApplicationDomainEx.MessageManager.Register<PageOpenMessage>(this, this.OnPageOpenMessage);
        }

        // ======================================================================
        // Property
        // ======================================================================

        #region ProjectName -- 项目名称

        private string projectName;
        /// <summary>
        /// 项目名称
        /// </summary>
        public string ProjectName
        {
            get { return projectName; }
            set { projectName = value; this.RaisePropertyChanged(nameof(ProjectName)); }
        }

        #endregion

        #region Scene -- 当前打开的场景

        private string scene;
        /// <summary>
        /// 当前打开的场景
        /// </summary>
        public string Scene
        {
            get { return scene; }
            set { scene = value; this.RaisePropertyChanged(nameof(Scene)); }
        }

        #endregion

        // ======================================================================
        // Message
        // ======================================================================

        /// <summary>
        /// 项目打开消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnProjectOpenMessage(ProjectOpenMessage msg)
        {
            if (ApplicationDomainEx.ProjectDbContext == null)
            {
                this.ProjectName = null;
                return;
            }

            this.ProjectName = System.IO.Path.GetFileNameWithoutExtension(ApplicationDomainEx.ProjectDbContext.Path);
        }

        /// <summary>
        /// 项目关闭消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnProjectCloseMessage(ProjectCloseMessage msg)
        {
            this.ProjectName = null;
        }

        /// <summary>
        /// 页打开消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnPageOpenMessage(PageOpenMessage msg)
        {
            this.Scene = msg.Page?.Scene;
        }
    }
}
