﻿using log4net;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    public class MediaResourceFileController
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(MediaResourceFileController));

        /// <summary>
        /// VIZ资源缩略图控制器
        /// </summary>
        /// <param name="support">支持</param>
        public MediaResourceFileController(IMediaResourceFileSupport support)
        {
            this.Support = support;
        }

        /// <summary>
        /// 支持
        /// </summary>
        public IMediaResourceFileSupport Support { get; private set; }


        /// <summary>
        /// 根目录
        /// </summary>
        public string RootPath { get; set; }
        /// <summary>
        /// 更新文件模型
        /// </summary>
        /// <param name="folder">文件夹</param>
        public void UpdateFileModels(MHResourceFolderModel folder)
        {
            // 文件夹对象不存在
            if (folder == null)
            {
                this.Support.FileModels = null;
                this.Support.SelectedFileModel = null;
                return;
            }

            //// 已经获取过文件
            if (folder.IsRefreshedFiles)
            {
                this.Support.FileModels = folder.Files;
                return;
            }

            WPFHelper.BeginInvoke(async () =>
            {
                try
                {
                    string header = string.Format("{0}GetListFile?filePath={1}", ApplicationDomainEx.MediaConfig.Url, folder.Path);
                    var FileResult = await MediaResourceFileService.PostObjectAsync<fileListResult, string>(header, "");
                    List<MHResourceFileModel> list = new List<MHResourceFileModel>();
                    // folder.Files = new System.Collections.ObjectModel.ObservableCollection<GHResourceFileModel>();
                    foreach (var file in FileResult.masterData)
                    {
                        try
                        {
                            MHResourceFileModel GHFile = new MHResourceFileModel();
                            if (ThumbnailHelper.IsImageByName(file.fileName))
                            {
                                GHFile.Name = file.fileName;
                                GHFile.Path = file.smallIconUrl;
                                string url = string.Format("{0}GetFile?filePath={1}", ApplicationDomainEx.MediaConfig.Url, GHFile.Path);
                                var fileResult = await MediaResourceFileService.GetImage(url);

                                GHFile.FileType = ResourceFileType.IMAGE;
                                Image img = Bitmap.FromStream(fileResult);

                                img = ThumbnailHelper.GetThumbnail(img, img.Width / 2, img.Height / 2);
                                Bitmap bmp = new Bitmap(img);
                                GHFile.ThumbnailBitmap = bmp;
                                list.Add(GHFile);

                            }
                            else if (ThumbnailHelper.IsVideo(file.fileName))
                            {
                                GHFile.Name = file.fileName;
                                GHFile.Path = file.smallIconUrl;
                                string strVedioPath = string.Format("{0}{1}", System.Environment.CurrentDirectory, "\\Resource\\VedioImage\\Vedio.jpeg");
                                Image vedioImage = Image.FromFile(strVedioPath);
                                vedioImage = ThumbnailHelper.GetThumbnail(vedioImage, vedioImage.Width / 2, vedioImage.Height / 2);
                                Bitmap vedioBtm = new Bitmap(vedioImage);
                                GHFile.ThumbnailBitmap = vedioBtm;
                                GHFile.FileType = ResourceFileType.Video;
                                list.Add(GHFile);
                            }
                        }
                        catch (Exception ex)
                        {
                            log.Error(ex.Message);
                        }

                    }

                    folder.Files = list.ToObservableCollection();

                    this.Support.FileModels = folder.Files;
                }
                catch(Exception ex)
                {
                    log.Error(ex.Message);
                }
            });
        }

        /// <summary>
        /// 移动文件
        /// </summary>
        /// <param name="oldPath"></param>
        /// <param name="newPath"></param>
        public async Task<fileListResult> MoveFile(string oldPath, string newPath)
        {
            string header = string.Format("{0}MoveFile?oldFile={1}&newFile={2}", ApplicationDomainEx.MediaConfig.Url, oldPath, newPath);
            var result = await MediaResourceFileService.PostObjectAsync<fileListResult, string>(header, "");
            return result;
        }

        /// <summary>
        /// 添加文件夹
        /// </summary>
        /// <param name="path"></param>
        public async Task<fileListResult> CreateFolder(string path)
        {
            string header = string.Format("{0}CreateFiles?filePath={1}", ApplicationDomainEx.MediaConfig.Url, path);
            var result = await MediaResourceFileService.PostObjectAsync<fileListResult, string>(header, "");
            return result;
        }


        /// <summary>
        /// 删除文件夹
        /// </summary>
        /// <param name="path"></param>
        public async Task<fileListResult> DeleteFolder(string path)
        {
            string header = string.Format("{0}DeleteFiles?filePath={1}", ApplicationDomainEx.MediaConfig.Url, path);
            var result = await MediaResourceFileService.PostObjectAsync<fileListResult, string>(header, "");
            return result;
        }

        /// <summary>
        /// 创建文件
        /// </summary>
        /// <param name="filePath"></param>
        /// <param name="fileName"></param>
        /// <returns></returns>
        public async Task<fileUploadResult> CreateFile(string filePath, string fileName)
        {
            string requestUri = string.Format("{0}UplodFile?filePath={1}", ApplicationDomainEx.MediaConfig.Url, this.Support.SelectedFolderModel.Path + "\\");

            fileUploadResult upLoadResult = await MediaResourceFileService.PostImage<fileUploadResult>(requestUri, filePath, fileName);

            if (upLoadResult == null)
                return null;

            return upLoadResult;

        }

        /// <summary>
        /// 删除文件
        /// </summary>
        /// <param name="path"></param>
        public async Task<fileListResult> DeleteFile(string path)
        {
            try
            {
                string header = string.Format("{0}DeleteFile?filePath={1}", ApplicationDomainEx.MediaConfig.Url, path);
                var result = await MediaResourceFileService.PostObjectAsync<fileListResult, string>(header, "");
                return result;
            }
            catch (Exception ex)
            {
                log.Error(ex.Message);
                return null;
            }


        }


        /// <summary>
        ///获取文件夹
        /// </summary>
        /// <returns></returns>

        public async Task<List<MHResourceFolderModel>> GetMeiaResourceFolder()
        {
            //  var config = 

            var folderResult = await MediaResourceFileService.PostObjectAsync<fileListResult, string>(string.Format("{0}GetListFiles", ApplicationDomainEx.MediaConfig.Url), "");
            if (folderResult == null)
                return null;
            RootPath = folderResult.rootPath;


            return GetFolder(folderResult.masterData);
        }


        /// <summary>
        /// 获取文件夹
        /// </summary>
        /// <param name="foldersDatas"></param>
        /// <returns></returns>
        private List<MHResourceFolderModel> GetFolder(List<ms> foldersDatas)
        {
            List<MHResourceFolderModel> listFolderModel = new List<MHResourceFolderModel>();

            foreach (var floderData in foldersDatas)
            {
                if (floderData.fileType == "floder")
                {
                    MHResourceFolderModel child = new MHResourceFolderModel();
                    child.Name = floderData.fileName;
                    child.FolderType = ResourceFolderType.Folder;
                    child.Path = floderData.smallIconUrl;

                    List<MHResourceFolderModel> children_list = GetFolder(floderData.m);

                    foreach (MHResourceFolderModel item in children_list)
                    {

                        child.Children.Add(item);
                        item.Parent = child;
                    }

                    listFolderModel.Add(child);
                }

            }

            return listFolderModel;
        }

        /// <summary>
        /// 销毁文件模型
        /// </summary>
        public void DisposeFileModels(MHResourceFolderModel folder)
        {
            if (folder == null || folder.Files == null || folder.Files.Count == 0)
                return;

            foreach (MHResourceFileModel file in folder.Files)
            {
                file.Dispose();
            }
        }
    }
}
