﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Service
{
    /// <summary>
    /// GH服务
    /// </summary>
    public class GHService
    {
        /// <summary>
        /// 获取请求令牌
        /// </summary>
        /// <returns>请求令牌</returns>
        public string GetAuthorization()
        {
            string user = "Admin";
            string password = "VizDb";
            string basic = Convert.ToBase64String(Encoding.UTF8.GetBytes($"{user}:{password}"));

            return $"Basic {basic}";
        }

        /// <summary>
        /// 获取Feed节点
        /// </summary>
        /// <param name="url">地址</param>
        /// <returns>Feed节点</returns>
        public GH_Feed_Node GetFeedNode(string url)
        {
            Dictionary<string, string> headers = new Dictionary<string, string>();
            headers["Authorization"] = this.GetAuthorization();
            string xml = HttpHelper.Get(url, headers, null);
            GH_Feed_Node node = GH_NodeHelper.CreateFeedFromXML(xml);

            return node;
        }

        /// <summary>
        /// 获取图片
        /// </summary>
        /// <param name="url">地址</param>
        /// <returns>图片对象</returns>
        public Bitmap GetImage(string url)
        {
            Dictionary<string, string> headers = new Dictionary<string, string>();
            headers["Authorization"] = this.GetAuthorization();
            MemoryStream ms = HttpHelper.GetStream(url, headers, null, null);
            Image img = Bitmap.FromStream(ms);
            Bitmap bmp = new Bitmap(img);

            ms.Dispose();
            img.Dispose();

            return bmp;
        }
    }
}
