﻿using LiteDB;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.UI.WebControls;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 项目数据上下文
    /// </summary>
    public class ProjectDbContext
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(ProjectDbContext));

        /// <summary>
        /// 数据库
        /// </summary>
        private ILiteDatabase Database;

        /// <summary>
        /// LiteDB数据库
        /// </summary>
        /// <param name="path">数据库路径</param>
        public ProjectDbContext(string path)
        {
            this.Path = path;

            this.Database = new LiteDatabase(path);

            this.PageTemplate = this.Database.GetCollection<PageTemplateEntity>();
            this.PageGroup = this.Database.GetCollection<PageGroupEntity>();
            this.Page = this.Database.GetCollection<PageEntity>();
        }

        /// <summary>
        /// 数据库文件路径
        /// </summary>
        public string Path { get; private set; }

        /// <summary>
        /// 页模板
        /// </summary>
        public ILiteCollection<PageTemplateEntity> PageTemplate { get; private set; }

        /// <summary>
        /// 页分组
        /// </summary>
        public ILiteCollection<PageGroupEntity> PageGroup { get; private set; }

        /// <summary>
        /// 页
        /// </summary>
        public ILiteCollection<PageEntity> Page { get; private set; }

        /// <summary>
        /// 根据ID获取控制字段， ID 为 TemplateID 或者 PageID
        /// </summary>
        /// <param name="id">TemplateID 或者 PageID</param>
        /// <returns>控制字段</returns>
        public ILiteCollection<ControlFieldEntity> GetControlFiled(Guid id)
        {
            string name = $"PAGE_{id.ToString().Replace("-", string.Empty)}";

            return this.Database.GetCollection<ControlFieldEntity>(name);
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.PageTemplate = null;
            this.PageGroup = null;
            this.Page = null;

            this.Database?.Dispose();
        }
    }
}