﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 应用程序域方法
    /// </summary>
    public partial class ApplicationDomainEx
    {
        /// <summary>
        /// 根据页获取场景信息
        /// </summary>
        /// <param name="page">页</param>
        /// <returns>场景信息</returns>
        public static SceneInfoModel GetSceneInfo(PageModel page)
        {
            SceneInfoModel sceneInfo = ApplicationDomainEx.SceneInfoList.FirstOrDefault(p => p.ScenePath == page.ScenePath && p.ConnGroupID == p.ConnGroupID);
            if (sceneInfo != null)
                return sceneInfo;

            lock (ApplicationDomainEx.SceneInfoList)
            {
                SceneInfoModel sceneInfoInner = ApplicationDomainEx.SceneInfoList.FirstOrDefault(p => p.ScenePath == page.ScenePath && p.ConnGroupID == p.ConnGroupID);
                if (sceneInfoInner != null)
                    return sceneInfoInner;

                sceneInfo = new SceneInfoModel();
                sceneInfo.ConnGroupID = page.ConnGroupID;
                sceneInfo.Scene = page.Scene;
                sceneInfo.ScenePath = page.ScenePath;

                ApplicationDomainEx.SceneInfoList.Add(sceneInfo);
            }

            return sceneInfo;
        }
    }
}
