﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 包装任务模型
    /// </summary>
    public class PackageTaskModel : ModelBase, IDisposable
    {
        /// <summary>
        /// 包装任务模型
        /// </summary>
        /// <param name="view">插件视图</param>
        public PackageTaskModel(IPluginView view)
        {
            this.View = view;
        }

        /// <summary>
        /// 全局任务ID统计
        /// </summary>
        private static int ALL_ID = 1;

        #region View -- 插件视图

        private IPluginView view;
        /// <summary>
        /// 插件视图
        /// </summary>
        public IPluginView View
        {
            get { return view; }
            private set { view = value; this.RaisePropertyChanged(nameof(View)); }
        }

        #endregion

        #region ID -- 编号

        private int id = ALL_ID++;
        /// <summary>
        /// 编号
        /// </summary>
        public int ID
        {
            get { return id; }
            private set { id = value; }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region IsPreviewEnabled -- 预览是否启用

        private bool isPreviewEnabled;
        /// <summary>
        /// 预览是否启用
        /// </summary>
        public bool IsPreviewEnabled
        {
            get { return isPreviewEnabled; }
            set { isPreviewEnabled = value; this.RaisePropertyChanged(nameof(IsPreviewEnabled)); }
        }

        #endregion

        #region IsTakeEnabled -- 上版是否启用

        private bool isTakeEnabled;
        /// <summary>
        /// 上版是否启用
        /// </summary>
        public bool IsTakeEnabled
        {
            get { return isTakeEnabled; }
            set { isTakeEnabled = value; this.RaisePropertyChanged(nameof(IsTakeEnabled)); }
        }

        #endregion

        #region IsRunning -- 是否正在运行

        private bool isRunning;
        /// <summary>
        /// 是否正在运行
        /// </summary>
        public bool IsRunning
        {
            get { return isRunning; }
            set { isRunning = value; this.RaisePropertyChanged(nameof(IsRunning)); }
        }

        #endregion

        #region UpdateMessage -- 更新消息

        private string updateMessage;
        /// <summary>
        /// 更新消息
        /// </summary>
        public string UpdateMessage
        {
            get { return updateMessage; }
            set { updateMessage = value; this.RaisePropertyChanged(nameof(UpdateMessage)); }
        }

        #endregion

        #region ErrorMessage -- 错误消息

        private string errorMessage;
        /// <summary>
        /// 错误消息
        /// </summary>
        public string ErrorMessage
        {
            get { return errorMessage; }
            set { errorMessage = value; this.RaisePropertyChanged(nameof(ErrorMessage)); }
        }

        #endregion

        #region Interval -- 触发间隔（单位：秒）

        private double interval = 5;
        /// <summary>
        /// 触发间隔（单位：秒）
        /// </summary>
        public double Interval
        {
            get { return interval; }
            set
            {
                interval = Math.Max(2, value);
                this.RaisePropertyChanged(nameof(Interval));
                if (this.TimerInfo == null)
                    return;

                this.TimerInfo.Interval = TimeSpan.FromSeconds(value);
            }
        }

        #endregion

        #region PreviewUpdateTime -- 预览更新时间

        private DateTime? previewUpdateTime;
        /// <summary>
        /// 预览更新时间
        /// </summary>
        public DateTime? PreviewUpdateTime
        {
            get { return previewUpdateTime; }
            set { previewUpdateTime = value; this.RaisePropertyChanged(nameof(PreviewUpdateTime)); }
        }

        #endregion

        #region TakeUpdateTime -- 上版更新时间

        private DateTime? takeUpdateTime;
        /// <summary>
        /// 上版更新时间
        /// </summary>
        public DateTime? TakeUpdateTime
        {
            get { return takeUpdateTime; }
            set { takeUpdateTime = value; this.RaisePropertyChanged(nameof(TakeUpdateTime)); }
        }

        #endregion

        #region PageModel -- 所属页模型

        private PageModel pageModel;
        /// <summary>
        /// 所属页模型
        /// </summary>
        public PageModel PageModel
        {
            get { return pageModel; }
            set { pageModel = value; this.RaisePropertyChanged(nameof(PageModel)); }
        }

        #endregion

        #region IsCheckConnScene -- 是否校验场景

        private bool isCheckConnScene = true;
        /// <summary>
        /// 是否校验场景
        /// </summary>
        /// <remarks>
        /// 如果获取到当前连接的场景与页模型场景名不一致，那么不进行更新
        /// </remarks>
        public bool IsCheckConnScene
        {
            get { return isCheckConnScene; }
            set { isCheckConnScene = value; this.RaisePropertyChanged(nameof(IsCheckConnScene)); }
        }

        #endregion

        /// <summary>
        /// 计时器信息
        /// </summary>
        public TimerInfo TimerInfo { get; set; }

        /// <summary>
        /// 是否可以执行
        /// </summary>
        public bool CanExecute { get; set; } = true;

        /// <summary>
        /// 预览更新行为
        /// </summary>
        public Action<ConnModel> PreviewUpdateAction { get; set; }

        /// <summary>
        /// 上版更新行为
        /// </summary>
        public Action<ConnModel> TakeUpdateAction { get; set; }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.PreviewUpdateAction = null;
            this.TakeUpdateAction = null;
        }
    }
}
