﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 页实体基类
    /// </summary>
    public abstract class PageEntityBase
    {
        /// <summary>
        /// 编号
        /// </summary>
        [BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// 场景
        /// </summary>
        public string Scene { get; set; }

        /// <summary>
        /// 场景路径
        /// </summary>
        public string ScenePath { get; set; }

        /// <summary>
        /// 缩略图地址
        /// </summary>
        public string ThumbnailUri { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 包装层
        /// </summary>
        public VizLayer Layer { get; set; }

        /// <summary>
        /// 引擎类型
        /// </summary>
        public EngineType EngineType { get; set; }

        /// <summary>
        /// 页类型
        /// </summary>
        public PageType PageType { get; set; }

        /// <summary>
        /// 排序索引
        /// </summary>
        public int Order { get; set; }
    }
}
