﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 页分组模型
    /// </summary>
    public class PageGroupModel : ModelBase
    {
        #region GroupID -- 分组ID

        private Guid guidID;
        /// <summary>
        /// 分组编号
        /// </summary>
        public Guid GroupID
        {
            get { return guidID; }
            set { guidID = value; this.RaisePropertyChanged(nameof(GroupID)); }
        }

        #endregion

        #region GroupName -- 分组名称

        private string groupName;
        /// <summary>
        /// 分组名称
        /// </summary>
        public string GroupName
        {
            get { return groupName; }
            set { groupName = value; this.RaisePropertyChanged(nameof(GroupName)); }
        }

        #endregion

        #region Order -- 排序

        private int order;
        /// <summary>
        /// 排序
        /// </summary>
        public int Order
        {
            get { return order; }
            set { order = value; this.RaisePropertyChanged(nameof(Order)); }
        }

        #endregion

        #region Pages -- 页集合

        private ObservableCollection<PageModel> pages = new ObservableCollection<PageModel>();
        /// <summary>
        /// 页集合
        /// </summary>
        public ObservableCollection<PageModel> Pages
        {
            get { return pages; }
            set { pages = value; this.RaisePropertyChanged(nameof(Pages)); }
        }

        #endregion

        // ===========================================================
        // 扩展属性
        // ===========================================================

        #region SelectedPages -- 当前选中的页集合

        private IList selectedPages;
        /// <summary>
        /// 当前选中的页集合
        /// </summary>
        public IList SelectedPages
        {
            get { return selectedPages; }
            set { selectedPages = value; this.RaisePropertyChanged(nameof(SelectedPages)); }
        }

        #endregion
    }
}
