﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    public class MHResourceFileModel : ResourceFileModelBase, IDisposable
    {
        /// <summary>
        /// GH 节点
        /// </summary>
        public GH_Entry_Node EntryNode { get; set; }

        #region FloderModel -- 所属文件夹模型

        private MHResourceFolderModel floderModel;
        /// <summary>
        /// 所属文件夹模型
        /// </summary>
        public MHResourceFolderModel FloderModel
        {
            get { return floderModel; }
            set { floderModel = value; this.RaisePropertyChanged(nameof(FloderModel)); }
        }

        #endregion

        #region Src -- 源

        private string src;
        /// <summary>
        /// 源
        /// </summary>
        public string Src
        {
            get { return src; }
            set { src = value; this.RaisePropertyChanged(nameof(Src)); }
        }

        #endregion

        #region Thumbnail -- 缩略图

        private string thumbnail;
        /// <summary>
        /// 缩略图
        /// </summary>
        public string Thumbnail
        {
            get { return thumbnail; }
            set { thumbnail = value; this.RaisePropertyChanged(nameof(Thumbnail)); }
        }

        #endregion

        #region MimeType -- 文件格式

        private string mimeType;
        /// <summary>
        /// 文件格式
        /// </summary>
        public string MimeType
        {
            get { return mimeType; }
            set { mimeType = value; this.RaisePropertyChanged(nameof(MimeType)); }
        }

        #endregion

        #region Path -- 路径

        private string path;
        /// <summary>
        /// 路径
        /// </summary>
        public string Path
        {
            get { return path; }
            set { path = value; this.RaisePropertyChanged(nameof(Path)); }
        }


        /// <summary>
        /// 日期
        /// </summary>
        private string date;

        public string Date
        {
            get { return date; }
            set { date = value; this.RaisePropertyChanged(nameof(Date)); }    
        }


        /// <summary>
        /// 文件大小
        /// </summary>
        public string fileSize;

        public string FileSize
        {
            get { return fileSize; }
            set { fileSize = value;this.RaisePropertyChanged(nameof(FileSize)); }
        }

        #endregion

        #region ResourcePath -- 资源路径

        /// <summary>
        /// 资源路径
        /// </summary>
        public string ResourcePath
        {
            get { return $"{this.FileType}*{this.Path}"; }
        }

        #endregion

        // ---------------------------------------------------------------------
        // 扩展属性

        #region ThumbnailBitmap -- 缩略图图片

        private Bitmap thumbnailBitmap;
        /// <summary>
        /// 缩略图图片
        /// </summary>
        public Bitmap ThumbnailBitmap
        {
            get { return thumbnailBitmap; }
            set { thumbnailBitmap = value; this.RaisePropertyChanged(nameof(ThumbnailBitmap)); }
        }

        #endregion


        #region----源图

        private Image originThumbnailBitmap;

        public Image OriginThumbnailBitmap
        {
            get { return originThumbnailBitmap; }
            set { originThumbnailBitmap = value; this.RaisePropertyChanged(nameof(OriginThumbnailBitmap)); }    
        }

        #endregion
        // ---------------------------------------------------------------------
        // 方法

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.ThumbnailBitmap?.Dispose();
            this.ThumbnailBitmap = null;
        }
    }
}
