﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Storage;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// Viz 配置
    /// </summary>
    public class VizConfig : IniConfigBase
    {
        /// <summary>
        /// Viz资源图片筛选器
        /// </summary>
        [Ini(Section = "Viz", DefaultValue = "图片|*.jpg;*.jpeg;*.bmp;*.png;", Type = typeof(string))]
        public string VIZ_IMAGE_FILTER { get; set; }

        /// <summary>
        /// Viz预览重启等待时间（单位：毫秒）
        /// </summary>
        [Ini(Section = "Viz", DefaultValue = "3000", Type = typeof(int))]
        public string VIZ_PREVIEW_RESTART_WAIT { get; set; }

        /// <summary>
        /// Viz预览编辑器类型: duplet、triplet 数据隐藏过滤器， 使用 "|" 分隔
        /// </summary>
        [Ini(Section = "Viz", DefaultValue = "position", Type = typeof(int))]
        public string VIZ_FIELD_EDIT_DUPLET_TRIPLET_HIDDEN_FILTER { get; set; }
    }
}
