﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 文件模型
    /// </summary>
    public class FileModel : ModelBase
    {
        /// <summary>
        /// 文件模型
        /// </summary>
        /// <param name="path">文件路径</param>
        public FileModel(string path)
        {
            this.Path = path;
            this.Name = System.IO.Path.GetFileName(path);
            this.Extension = System.IO.Path.GetExtension(path);
        }

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Path -- 路径

        private string path;
        /// <summary>
        /// 路径
        /// </summary>
        public string Path
        {
            get { return path; }
            set { path = value; this.RaisePropertyChanged(nameof(Path)); }
        }

        #endregion

        #region Extension -- 文件扩展名

        private string extension;
        /// <summary>
        /// 文件扩展名
        /// </summary>
        public string Extension
        {
            get { return extension; }
            set { extension = value; this.RaisePropertyChanged(nameof(Extension)); }
        }

        #endregion

        #region Parent -- 父级节点

        private FolderModel parent;
        /// <summary>
        /// 父级节点
        /// </summary>
        public FolderModel Parent
        {
            get { return parent; }
            set { parent = value; this.RaisePropertyChanged(nameof(Parent)); }
        }

        #endregion
    }
}
