﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 插件视图
    /// </summary>
    public interface IPluginView : IDisposable
    {
        /// <summary>
        /// 上版
        /// </summary>
        /// <param name="conns">连接</param>
        void TakIn(ConnModel conn);

        /// <summary>
        /// 继续
        /// </summary>
        /// <param name="conn">连接</param>
        void TakeContinue(ConnModel conn);

        /// <summary>
        /// 下版子
        /// </summary>
        /// <param name="conn">连接</param>
        void TakeOut(ConnModel conn);

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="conn">连接</param>
        void TakeUpdate(ConnModel conn);

        /// <summary>
        /// 预览上版子
        /// </summary>
        /// <param name="conn">连接</param>
        void PreviewIn(ConnModel conn);

        /// <summary>
        /// 预览继续
        /// </summary>
        /// <param name="conn">连接</param>
        void PreviewContinue(ConnModel conn);

        /// <summary>
        /// 预览下版
        /// </summary>
        /// <param name="conn">连接</param>
        void PreviewOut(ConnModel conn);

        /// <summary>
        /// 打开页后触发
        /// </summary>
        /// <param name="page">页</param>
        void PageOpend(PageModel page);
    }
}
