﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 调试视图模型
    /// </summary>
    public class DebugViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(DebugViewModel));

        public DebugViewModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初试化命令
        /// </summary>
        private void InitCommand()
        {
            // Docking
            this.SaveLayoutCommand = new VCommand(this.SaveLayout);
            this.LoadLayoutCommand = new VCommand(this.LoadLayout);

            // Log
            this.ErrorLogCommand = new VCommand(this.ErrorLog);

            // Project
            this.ProjectPanelCommand = new VCommand(this.ProjectPanel);
        }

        // ======================================================================
        // Command
        // ======================================================================

        // ---------------------------------------------------------
        // Docking

        #region SaveLayoutCommand -- 保存布局命令

        /// <summary>
        /// 保存布局命令
        /// </summary>
        public VCommand SaveLayoutCommand { get; set; }

        /// <summary>
        /// 保存布局
        /// </summary>
        private void SaveLayout()
        {
            IMainViewService service = ApplicationDomainEx.ServiceManager.GetService<IMainViewService>(ViewServiceKeys.MAIN_VIEW_SERVICE);
            if (service == null)
                return;

            service.SaveLayout();
        }

        #endregion

        #region LoadLayoutCommand -- 加载布局命令

        /// <summary>
        /// 加载布局命令
        /// </summary>
        public VCommand LoadLayoutCommand { get; set; }

        /// <summary>
        /// 加载布局
        /// </summary>
        private void LoadLayout()
        {
            IMainViewService service = ApplicationDomainEx.ServiceManager.GetService<IMainViewService>(ViewServiceKeys.MAIN_VIEW_SERVICE);
            if (service == null)
                return;

            service.LoadLayout();
        }

        #endregion

        // ---------------------------------------------------------
        // Log

        #region ErrorLogCommand -- 错误日志命令

        /// <summary>
        /// 错误日志命令
        /// </summary>
        public VCommand ErrorLogCommand { get; set; }

        /// <summary>
        /// 错误日志
        /// </summary>
        private void ErrorLog()
        {
            log.Error("测试错误日志!");
        }

        #endregion

        // ---------------------------------------------------------
        // Project

        #region ProjectPanelCommand -- 项目面板命令

        /// <summary>
        /// 项目面板命令
        /// </summary>
        public VCommand ProjectPanelCommand { get; set; }

        /// <summary>
        /// 项目面板
        /// </summary>
        private void ProjectPanel()
        {
            OpenProjectWindow window = new OpenProjectWindow();
            window.Show();
        }

        #endregion
    }
}
