﻿using DevExpress.Utils.Html;
using DevExpress.Xpf.Core;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Media.Animation;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 打开项目窗口模型
    /// </summary>
    public class OpenProjectWindowModel : ProjectTreePanelModel
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(OpenProjectWindowModel));

        public OpenProjectWindowModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.OpenProjectCommand = new VCommand(this.OpenProject);
        }

        // ==========================================================================
        // Config
        // ==========================================================================


        // ==========================================================================
        // Controller & Service
        // ==========================================================================


        // ==========================================================================
        // Property
        // ==========================================================================

        // ==========================================================================
        // Command
        // ==========================================================================

        #region OpenProjectCommand -- 打开项目命令

        /// <summary>
        /// 打开项目命令
        /// </summary>
        public VCommand OpenProjectCommand { get; set; }

        /// <summary>
        /// 打开项目命令
        /// </summary>
        private void OpenProject()
        {
            if (this.SelectedFileModel == null)
            {
                DXMessageBox.Show("请选择项目文件");
                return;
            }

            Window window = this.GetWindow();
            if (window == null)
                return;

            window.DialogResult = true;
            window.Close();
        }

        #endregion

        // ==========================================================================
        // Protected Function
        // ==========================================================================

        /// <summary>
        /// 文件双击命令
        /// </summary>
        protected override void OnFileDoubleClick()
        {
            this.OpenProject();
        }
    }
}