﻿using DevExpress.Xpf.Core;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 保存项目窗口模型
    /// </summary>
    public class SaveProjectWindowModel : ProjectTreePanelModel
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(SaveProjectWindowModel));

        public SaveProjectWindowModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.SaveProjectCommand = new VCommand(this.SaveProject);
        }

        // ==========================================================================
        // Config
        // ==========================================================================


        // ==========================================================================
        // Controller & Service
        // ==========================================================================


        // ==========================================================================
        // Property
        // ==========================================================================

        #region ProjectName -- 项目名

        private string projectName;
        /// <summary>
        /// 项目名
        /// </summary>
        public string ProjectName
        {
            get { return projectName; }
            set { projectName = value; this.RaisePropertyChanged(nameof(ProjectName)); }
        }

        #endregion

        // ==========================================================================
        // Command
        // ==========================================================================

        #region SaveProjectCommand -- 保存项目命令

        /// <summary>
        /// 打开项目命令
        /// </summary>
        public VCommand SaveProjectCommand { get; set; }

        /// <summary>
        /// 保存项目
        /// </summary>
        private void SaveProject()
        {
            if (this.SelectedFolderModel == null)
            {
                DXMessageBox.Show("请选择要保存项目的目录");
                return;
            }

            if (string.IsNullOrWhiteSpace(this.ProjectName))
            {
                DXMessageBox.Show("请输入项目名");
            }

            string file = this.ProjectName;
            if (!this.ProjectName.ToLower().EndsWith(ApplicationConstants.PROJECT_FILE_EXTENSION))
            {
                file = $"{file}{ApplicationConstants.PROJECT_FILE_EXTENSION}";
                this.ProjectName = file;
            }

            string path = System.IO.Path.Combine(this.SelectedFolderModel.Path, file);

            if (System.IO.File.Exists(path))
            {
                var result = DXMessageBox.Show($"项目：\"{file}\" 已经存在，是否覆盖", "提示", MessageBoxButton.YesNo);

                if (result != MessageBoxResult.Yes)
                    return;
            }

            Window window = this.GetWindow();
            window.DialogResult = true;
            window.Close();
        }

        #endregion

        // ==========================================================================
        // protected Function
        // ==========================================================================

        /// <summary>
        /// 选中的文件改变时触发
        /// </summary>
        /// <param name="oldValue">旧值</param>
        /// <param name="newValue">新值</param>
        protected override void OnSelectedFileModelChanged(FileModel oldValue, FileModel newValue)
        {
            this.ProjectName = newValue?.Name;
        }
    }
}