﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// Viz配置实体
    /// </summary>
    public class VizConfigEntity
    {
        /// <summary>
        /// 编号
        /// </summary>
        [BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// GH IP地址
        /// </summary>
        public string GH_IP { get; set; } = "localhost";

        /// <summary>
        /// GH 端口
        /// </summary>
        public int GH_Port { get; set; } = 19398;

        /// <summary>
        /// GH 服务名
        /// </summary>
        public string GH_ServerName { get; set; } = "VizDbServer";

        /// <summary>
        /// GH 用户名
        /// </summary>
        public string GH_UserName { get; set; } = "Admin";

        /// <summary>
        /// GH 密码
        /// </summary>
        public string GH_Password { get; set; } = "VizDb";

        /// <summary>
        /// VIZ_IP
        /// </summary>
        public string VIZ_IP { get; set; } = "localhost";

        /// <summary>
        /// VIZ 端口
        /// </summary>
        public int VIZ_Port { get; set; } = 6100;

        /// <summary>
        /// VIZ用户名
        /// </summary>
        public string VIZ_UserName { get; set; } = "Guest";

        /// <summary>
        /// VIZ密码
        /// </summary>
        public string VIZ_Password { get; set; }

        /// <summary>
        /// VIZ 引擎3路径
        /// </summary>
        public string VIZ_Eng3Path { get; set; }

        /// <summary>
        /// VIZ 引擎4路径
        /// </summary>
        public string VIZ_Eng4Path { get; set; }

        /// <summary>
        /// 引擎完整类型
        /// </summary>
        public EngineFullType EngineFullType { get; set; } = EngineFullType.VIZ_Eng4;

        /// <summary>
        /// 插件分组
        /// </summary>
        public string PluginGroup { get; set; }

        /// <summary>
        /// 当前打开的项目路径
        /// </summary>
        public string ProjectPath { get; set; }
    }
}
