﻿using DevExpress.Xpf.Grid;
using DevExpress.Xpf.Bars;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Common
{
    /// <summary>
    /// 列表控件辅助类
    /// </summary>
    public static class GridControlHelper
    {
        /// <summary>
        /// 保留菜单标志
        /// </summary>
        public const string KEEP_MENU_TAG = "VIZ";

        /// <summary>
        /// 移除所有默认的菜单
        /// </summary>
        /// <param name="e">菜单事件参数</param>
        public static void RemoveAllDefaultMenuItem(GridMenuEventArgs e)
        {
            if (e.Items == null || e.Items.Count == 0)
                return;

            foreach (var item in e.Items)
            {
                if (!KEEP_MENU_TAG.Equals(item.Tag))
                {
                    e.Customizations.Add(new RemoveBarItemAndLinkAction() { ItemName = item.Name });

                    continue;
                }

                VCommand cmd = item.Command as VCommand;
                cmd?.RaiseCanExecute();
            }
        }
    }
}
