﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;

namespace VIZ.Package.Module.Resource
{
    /// <summary>
    /// 富文本到文本转化器
    /// </summary>
    public class RichText2TextConverter : IValueConverter
    {
        /// <summary>
        /// 富文本左侧
        /// </summary>
        public const string RICH_TEXT_LEFT = "<fo:wrapper xmlns:fo=\"http://www.w3.org/1999/XSL/Format\"><![CDATA[";

        /// <summary>
        /// 富文本右侧
        /// </summary>
        public const string RICH_TEXT_RIGHT = "]]></fo:wrapper>";

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string text = value?.ToString();
            if (string.IsNullOrWhiteSpace(text))
                return text;

            text = text.Replace(RICH_TEXT_LEFT, string.Empty);
            text = text.Replace(RICH_TEXT_RIGHT, string.Empty);

            return text;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string text = value?.ToString();
            if (string.IsNullOrWhiteSpace(text))
                return text;

            return $"{RICH_TEXT_LEFT}{text}{RICH_TEXT_RIGHT}";
        }
    }
}
