﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 页模型拷贝控制器
    /// </summary>
    public class PageModelCopyController
    {
        /// <summary>
        /// 控制对象服务
        /// </summary>
        private ControlObjectService controlObjectService = new ControlObjectService();

        /// <summary>
        /// GH服务
        /// </summary>
        private GHService ghService = new GHService();

        /// <summary>
        /// 等待拷贝页集合
        /// </summary>
        public List<PageModel> WaitCopyPages { get; set; }

        /// <summary>
        /// 拷贝分组
        /// </summary>
        /// <param name="srcGroup">待拷贝分组</param>
        /// <returns>拷贝分组</returns>
        public PageGroupModel CopyGroup(PageGroupModel srcGroup)
        {
            PageGroupModel destGroup = new PageGroupModel();
            destGroup.GroupID = Guid.NewGuid();
            destGroup.GroupName = srcGroup.GroupName;
            destGroup.Order = srcGroup.Order;

            foreach (PageModel srcPage in srcGroup.Pages)
            {
                PageModel destPage = this.CopyPage(srcPage);
                destPage.PageGroupID = destGroup.GroupID;
                destGroup.Pages.Add(destPage);
            }

            return destGroup;
        }

        /// <summary>
        /// 拷贝页
        /// </summary>
        /// <param name="template">待拷贝模板</param>
        /// <returns></returns>
        public PageModel CopyPage(PageTemplateModel template, PageAddViewModel vm, PageGroupModel pageGroup)
        {
            PageModel page = new PageModel();
            page.PageID = Guid.NewGuid();
            page.PageGroupID = pageGroup.GroupID;
            page.Scene = template.Scene;
            page.ScenePath = template.ScenePath;
            page.ThumbnailUri = template.ThumbnailUri;
            page.Remark = vm.Remark;
            page.Layer = vm.Layer;
            page.EngineType = template.EngineType;
            page.PageType = template.PageType;
            page.TemplateID = template.TemplateID;
            page.ThumbnailBitmap = template.ThumbnailBitmap;
            page.PluginID = vm.SelectedTemplatePlugin?.ID;
            page.PluginName = vm.SelectedTemplatePlugin?.Name;
            page.PageNum = pageGroup.Pages.Count == 0 ? 1 : (pageGroup.Pages.Max(p => p.PageNum) + 1);

            // 关联连接分组
            ConnGroupModel conn = ApplicationDomainEx.ConnGroups?.FirstOrDefault(p => p.IsDefault);
            page.ConnGroupID = conn != null ? conn.GroupID : Guid.Empty;

            // 将模板控制对象拷贝值页控制对象
            this.controlObjectService.CopyControlObjects(template.TemplateID, page.PageID);

            // 将模板控制字段拷贝至页控制字段
            this.controlObjectService.CopyControlFields(template.TemplateID, page.PageID);

            return page;
        }

        /// <summary>
        /// 拷贝页
        /// </summary>
        /// <param name="srcPage">待拷贝页</param>
        /// <returns>拷贝页</returns>
        public PageModel CopyPage(PageModel srcPage)
        {
            // 当前打开的页为页模型时可以被拷贝
            if (srcPage == null)
                return null;

            PageModel page = new PageModel();
            page.PageID = Guid.NewGuid();
            page.PageGroupID = srcPage.PageGroupID;
            page.Scene = srcPage.Scene;
            page.ScenePath = srcPage.ScenePath;
            page.ThumbnailUri = srcPage.ThumbnailUri;
            page.Remark = srcPage.Remark;
            page.Layer = srcPage.Layer;
            page.EngineType = srcPage.EngineType;
            page.PageType = srcPage.PageType;
            page.TemplateID = srcPage.TemplateID;
            page.ThumbnailBitmap = srcPage.ThumbnailBitmap;
            page.PluginID = srcPage.PluginID;
            page.PluginName = srcPage.PluginName;
            page.ConnGroupID = srcPage.ConnGroupID;
            page.SceneInfo = srcPage.SceneInfo;

            // 将模板控制对象拷贝值页控制对象
            this.controlObjectService.CopyControlObjects(srcPage.PageID, page.PageID);

            // 将模板控制字段拷贝至页控制字段
            this.controlObjectService.CopyControlFields(srcPage.PageID, page.PageID);

            return page;
        }
    }
}
