﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 页分组命名视图模型
    /// </summary>
    public class PageGroupRenameViewModel : ViewModelBase
    {
        public PageGroupRenameViewModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.EnterCommand = new VCommand(this.Enter);
            this.CancelCommand = new VCommand(this.Cancel);
        }

        // ======================================================================================
        // Property
        // ======================================================================================

        #region PageGroupName -- 页分组名称

        private string pageGroupName;
        /// <summary>
        /// 页分组名称
        /// </summary>
        public string PageGroupName
        {
            get { return pageGroupName; }
            set { pageGroupName = value; this.RaisePropertyChanged(nameof(PageGroupName)); }
        }

        #endregion

        // ======================================================================================
        // Command
        // ======================================================================================

        #region EnterCommand -- 确定命令

        /// <summary>
        /// 确定命令
        /// </summary>
        public VCommand EnterCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            Window window = this.GetWindow();
            window.DialogResult = true;

            window.Close();
        }

        #endregion

        #region CancelCommand -- 取消命令

        /// <summary>
        /// 取消命令
        /// </summary>
        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            Window window = this.GetWindow();
            window.DialogResult = false;

            window.Close();
        }

        #endregion
    }
}
